/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class SoulParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    SoulParticle(ClientLevel level, double x, double y, double z, double velX, double velY, double velZ, SpriteSet sprites) {
        super(level, x, y, z, velX, velY, velZ);
        this.xd = (this.random.nextDouble() * 2.0 - 1.0) / 10.0;
        this.yd = 0.1 + this.random.nextDouble() / 10.0;
        this.zd = (this.random.nextDouble() * 2.0 - 1.0) / 10.0;
        this.lifetime = 16 + this.random.nextInt(5);
        this.sprites = sprites;
        this.scale(3.0f + this.random.nextFloat());
        this.setSpriteFromAge(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SoulParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

