/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector3f;

public class ColorScaleParticleType
extends ParticleType<Options> {
    private final MapCodec<Options> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VECTOR3F.fieldOf("color").forGetter(Options::color), (App)Codec.FLOAT.fieldOf("scale").forGetter(Options::scale)).apply((Applicative)instance, (x$0, x$1) -> new Options((Vector3f)x$0, (float)x$1)));
    private final StreamCodec<? super RegistryFriendlyByteBuf, Options> streamCodec = StreamCodec.ofMember(Options::encode, x$0 -> new Options((FriendlyByteBuf)x$0));

    public ColorScaleParticleType(boolean overrideLimiter) {
        super(overrideLimiter);
    }

    public ColorScaleParticleType() {
        this(false);
    }

    public Options withColor(float r, float g, float b) {
        return new Options(r, g, b, 1.0f);
    }

    public Options withColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Options(r, g, b, 1.0f);
    }

    public Options withColorAndScale(float r, float g, float b, float scale) {
        return new Options(r, g, b, scale);
    }

    public Options withColorAndScale(int color, float scale) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Options(r, g, b, scale);
    }

    public MapCodec<Options> codec() {
        return this.codec;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, Options> streamCodec() {
        return this.streamCodec;
    }

    public class Options
    implements ParticleOptions {
        public final float r;
        public final float g;
        public final float b;
        public final float scale;

        private Options(float r, float g, float b, float scale) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
        }

        private Options(FriendlyByteBuf buffer) {
            this.r = buffer.readFloat();
            this.g = buffer.readFloat();
            this.b = buffer.readFloat();
            this.scale = buffer.readFloat();
        }

        private Options(Vector3f vec, float scale) {
            this(vec.x(), vec.y(), vec.z(), scale);
        }

        public Vector3f color() {
            return new Vector3f(this.r, this.g, this.b);
        }

        public float scale() {
            return this.scale;
        }

        public ParticleType<?> getType() {
            return ColorScaleParticleType.this;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
        }
    }
}

