/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.mc.loadingbackgrounds;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.architectury.platform.Platform;
import dev.foxgirl.bundled.aY;
import dev.foxgirl.bundled.ap;
import dev.foxgirl.bundled.aq;
import dev.foxgirl.bundled.ax;
import dev.foxgirl.bundled.ba;
import dev.foxgirl.mc.loadingbackgrounds.LoadingBackgroundsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class Config {
    public static final Companion Companion = new Companion(null);
    private double secondsStay = 5.0;
    private double secondsFade = 0.5;
    private float brightness = 1.0f;
    private Position position = Position.BOTTOM_RIGHT;
    private boolean shouldLoadResources = true;
    private static final String DEFAULT = "// Loading Backgrounds v2 configuration JSON file\n{\n  // Amount of time that each background is displayed for\n  \"secondsStay\": 5.0,\n  // Amount of time it takes to fade between backgrounds\n  \"secondsFade\": 0.5,\n  // Background brightness, between 0.0 and 1.0\n  \"brightness\": 1.0,\n  // Level loading indicator position\n  // One of \"CENTER\", \"BOTTOM_LEFT\", \"BOTTOM_RIGHT\", \"TOP_LEFT\", or \"TOP_RIGHT\"\n  \"position\": \"BOTTOM_RIGHT\",\n  // Should we try to forcefully load any resource packs that could contain background images?\n  \"shouldLoadResources\": true\n}";

    public final double getSecondsStay() {
        return this.secondsStay;
    }

    public final void setSecondsStay(double d2) {
        this.secondsStay = d2;
    }

    public final double getSecondsFade() {
        return this.secondsFade;
    }

    public final void setSecondsFade(double d2) {
        this.secondsFade = d2;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(float f2) {
        this.brightness = f2;
    }

    public final Position getPosition() {
        return this.position;
    }

    public final void setPosition(Position position) {
        ba.checkNotNullParameter((Object)position, "");
        this.position = position;
    }

    public final boolean getShouldLoadResources() {
        return this.shouldLoadResources;
    }

    public final void setShouldLoadResources(boolean bl2) {
        this.shouldLoadResources = bl2;
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Config load() {
            Path path = Platform.getConfigFolder().resolve("loadingbackgrounds.json");
            Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();
            try {
                Closeable closeable = Files.newBufferedReader(path);
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl2 = false;
                    Object object = gson.fromJson((Reader)reader, Config.class);
                    ba.checkNotNullExpressionValue(object, "");
                    Config config = (Config)object;
                    return config;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    ax.closeFinally(closeable, throwable);
                }
            }
            catch (NoSuchFileException cause) {
                LoadingBackgroundsKt.getLogger().warn("Config file loadingbackgrounds.json not found, saving default config");
            }
            catch (JsonParseException cause) {
                LoadingBackgroundsKt.getLogger().warn("Config file loadingbackgroudns.json is invalid! " + cause.getMessage());
            }
            catch (Exception cause) {
                LoadingBackgroundsKt.getLogger().error("Exception while reading config file", (Throwable)cause);
            }
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)DEFAULT, new OpenOption[0]);
            }
            catch (Exception cause) {
                LoadingBackgroundsKt.getLogger().error("Exception while saving default config file", (Throwable)cause);
            }
            Object object = gson.fromJson(DEFAULT, Config.class);
            ba.checkNotNullExpressionValue(object, "");
            return (Config)object;
        }

        public /* synthetic */ Companion(aY $constructor_marker) {
            this();
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position CENTER = new Position();
        public static final /* enum */ Position TOP_LEFT = new Position();
        public static final /* enum */ Position TOP_RIGHT = new Position();
        public static final /* enum */ Position BOTTOM_LEFT = new Position();
        public static final /* enum */ Position BOTTOM_RIGHT = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ ap $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        public static ap<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.CENTER, Position.TOP_LEFT, Position.TOP_RIGHT, Position.BOTTOM_LEFT, Position.BOTTOM_RIGHT};
            $ENTRIES = aq.enumEntries((Enum[])$VALUES);
        }
    }
}

