/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.mc.loadingbackgrounds.mixin;

import dev.architectury.platform.Platform;
import dev.foxgirl.mc.loadingbackgrounds.Config;
import dev.foxgirl.mc.loadingbackgrounds.LoadingBackgrounds;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LevelLoadingScreen.class})
public abstract class LevelLoadingScreenMixin
extends Screen {
    @Shadow
    @Final
    private StoringChunkProgressListener progressListener;

    private LevelLoadingScreenMixin(Component title) {
        super(title);
    }

    @ModifyVariable(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="STORE"), ordinal=2)
    private int loadingbackgrounds$render$0(int x2) {
        Config.Position position = LoadingBackgrounds.getConfig().getPosition();
        if (position != Config.Position.CENTER) {
            int width = this.width;
            int diameter = this.progressListener.getDiameter();
            switch (position.ordinal()) {
                case 1: 
                case 3: {
                    return diameter + diameter / 4;
                }
                case 2: 
                case 4: {
                    return width - diameter - diameter / 4;
                }
            }
        }
        return x2;
    }

    @ModifyVariable(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="STORE"), ordinal=3)
    private int loadingbackgrounds$render$1(int y2) {
        Config.Position position = LoadingBackgrounds.getConfig().getPosition();
        if (position != Config.Position.CENTER) {
            int height = this.height;
            int diameter = this.progressListener.getDiameter();
            String version = Platform.getMinecraftVersion();
            if (!version.startsWith("1.20") || version.equals("1.20.5") || version.equals("1.20.6")) {
                switch (position.ordinal()) {
                    case 1: 
                    case 2: {
                        return diameter + diameter / 4 + 15;
                    }
                    case 3: 
                    case 4: {
                        return height - diameter - diameter / 4;
                    }
                }
            } else {
                switch (position.ordinal()) {
                    case 1: 
                    case 2: {
                        return diameter + diameter / 4;
                    }
                    case 3: 
                    case 4: {
                        return height - diameter - diameter / 4 - 30;
                    }
                }
            }
        }
        return y2;
    }
}

