/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.world.entity.monster.Surrendered;
import fuzs.illagerinvasion.world.entity.projectile.FlyingMagma;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class Firecaller
extends SpellcasterIllager {
    private int conjureSkullCooldown = 160;
    private int areaDamageCooldown = 300;

    public Firecaller(EntityType<? extends Firecaller> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 15;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTargetOrWololoTarget());
        this.goalSelector.addGoal(4, (Goal)new ConjureSkullGoal());
        this.goalSelector.addGoal(3, (Goal)new AreaDamageGoal());
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 12.0f, 0.6, 1.0));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        --this.conjureSkullCooldown;
        --this.areaDamageCooldown;
    }

    public boolean isAlliedTo(Entity other) {
        LivingEntity livingEntity;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.isAlliedTo((Entity)((Vex)other).getOwner());
        }
        return other instanceof LivingEntity && (livingEntity = (LivingEntity)other).getType().is(EntityTypeTags.ILLAGER_FRIENDS) && this.getTeam() == null && other.getTeam() == null;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.FIRECALLER_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.FIRECALLER_DEATH_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSoundEvents.FIRECALLER_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.FIRECHARGE_USE;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Firecaller.this);
        }

        public void tick() {
            if (Firecaller.this.getTarget() != null) {
                Firecaller.this.getLookControl().setLookAt((Entity)Firecaller.this.getTarget(), (float)Firecaller.this.getMaxHeadYRot(), (float)Firecaller.this.getMaxHeadXRot());
            }
        }
    }

    public class ConjureSkullGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureSkullGoal() {
            super((SpellcasterIllager)Firecaller.this);
        }

        private List<LivingEntity> getTargets() {
            return Firecaller.this.level().getEntitiesOfClass(LivingEntity.class, Firecaller.this.getBoundingBox().inflate(5.0), entity -> entity instanceof Player || entity instanceof IronGolem);
        }

        public boolean canUse() {
            if (Firecaller.this.getTarget() == null) {
                return false;
            }
            if (Firecaller.this.conjureSkullCooldown > 0) {
                return false;
            }
            return Firecaller.this.conjureSkullCooldown < 0 && !Firecaller.this.isCastingSpell() && this.getTargets().isEmpty();
        }

        public void tick() {
            if (Firecaller.this.level() instanceof ServerLevel) {
                ((ServerLevel)Firecaller.this.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, Firecaller.this.getX(), Firecaller.this.getY() + 2.5, Firecaller.this.getZ(), 2, 0.2, 0.2, 0.2, 0.05);
                ((ServerLevel)Firecaller.this.level()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, Firecaller.this.getX(), Firecaller.this.getY() + 2.5, Firecaller.this.getZ(), 2, 0.2, 0.2, 0.2, 0.05);
            }
            super.tick();
        }

        private void shootSkullAt(LivingEntity target) {
            this.shootSkullAt(target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ());
        }

        private void shootSkullAt(double targetX, double targetY, double targetZ) {
            double d = Firecaller.this.getX();
            double e = Firecaller.this.getY() + 2.5;
            double f = Firecaller.this.getZ();
            double g = targetX - d;
            double h = targetY - e;
            double i = targetZ - f;
            FlyingMagma Magma = new FlyingMagma(Firecaller.this.level(), (LivingEntity)Firecaller.this, g, h, i);
            Magma.setOwner((Entity)Firecaller.this);
            Magma.setPosRaw(d, e, f);
            Firecaller.this.level().addFreshEntity((Entity)Magma);
        }

        protected void performSpellCasting() {
            this.shootSkullAt(Firecaller.this.getTarget());
            if (Firecaller.this.level() instanceof ServerLevel) {
                double x = Firecaller.this.getX();
                double y = Firecaller.this.getY() + 2.5;
                double z = Firecaller.this.getZ();
                ((ServerLevel)Firecaller.this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 40, 0.4, 0.4, 0.4, 0.15);
            }
            Firecaller.this.conjureSkullCooldown = 160;
        }

        protected int getCastWarmupTime() {
            return 60;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.FIRECALLER_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    public class AreaDamageGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public AreaDamageGoal() {
            super((SpellcasterIllager)Firecaller.this);
        }

        public boolean canUse() {
            if (Firecaller.this.getTarget() == null) {
                return false;
            }
            if (Firecaller.this.isCastingSpell()) {
                return false;
            }
            return Firecaller.this.areaDamageCooldown <= 0;
        }

        private List<LivingEntity> getTargets() {
            return Firecaller.this.level().getEntitiesOfClass(LivingEntity.class, Firecaller.this.getBoundingBox().inflate(6.0), entity -> !(entity instanceof AbstractIllager) && !(entity instanceof Surrendered) && !(entity instanceof Ravager));
        }

        private void buff(LivingEntity entity) {
            entity.push(0.0, (double)1.2f, 0.0);
            entity.hurt(Firecaller.this.damageSources().magic(), 6.0f);
            entity.setRemainingFireTicks(120);
            double x = entity.getX();
            double y = entity.getY() + 1.0;
            double z = entity.getZ();
            ((ServerLevel)Firecaller.this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y + 1.0, z, 10, 0.2, 0.2, 0.2, 0.015);
            BlockPos blockPos = entity.blockPosition();
            Firecaller.this.level().setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
        }

        protected void performSpellCasting() {
            this.getTargets().forEach(this::buff);
            Firecaller.this.areaDamageCooldown = 300;
        }

        protected int getCastWarmupTime() {
            return 50;
        }

        protected int getCastingTime() {
            return 50;
        }

        protected int getCastingInterval() {
            return 400;
        }

        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSoundEvents.FIRECALLER_CAST_SOUND_EVENT.value();
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return ModRegistry.PROVOKE_ILLAGER_SPELL;
        }
    }
}

