/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleSelectionList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PackConfigScreen
extends Screen {
    private static final Component MOD_TEXT = Component.translatable((String)"screen.config.mod");
    private static final Component CLOSE_TEXT = Component.translatable((String)"screen.config.close");
    private static final Component FEATURES_TEXT = Component.translatable((String)"screen.config.features");
    private static final Component PACK_ID_TEXT = Component.translatable((String)"config.pack_id");
    private static final Component PARTNER_ID_TEXT = Component.translatable((String)"config.partner_id");
    private static final Component PACK_EDIT_MODE_TEXT = Component.translatable((String)"config.pack_edit_mode");
    public static final float SPLIT = 0.3f;
    private Screen parent;
    private ModuleSelectionList moduleSelectionList;
    private TextConfigEditBox packIdEditBox;
    private TextConfigEditBox partnerIdEditBox;
    private TickBoxConfigComponent enableConfigScreenTickButton;
    public static boolean hasChanged;

    public PackConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.config.pack.title"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int splitWidth = (int)((float)this.width * 0.3f);
        this.moduleSelectionList = new ModuleSelectionList(this.minecraft, this.width - splitWidth, this.height, 45, 30);
        for (IModule module : ModRoot.get().modules.getAll()) {
            this.moduleSelectionList.addEntry(new ModuleSelectionList.PackEntry(module));
        }
        this.moduleSelectionList.setX(splitWidth);
        this.addRenderableWidget((GuiEventListener)this.moduleSelectionList);
        int boxWidth = 100;
        this.packIdEditBox = new TextConfigEditBox(new StringHolder(GlobalConfigs.packId), this.font, (splitWidth - boxWidth) / 2, 75, boxWidth, 20, PACK_ID_TEXT);
        this.addRenderableWidget((GuiEventListener)this.packIdEditBox);
        this.partnerIdEditBox = new TextConfigEditBox(new StringHolder(GlobalConfigs.partnerId), this.font, (splitWidth - boxWidth) / 2, 125, boxWidth, 20, PARTNER_ID_TEXT);
        this.addRenderableWidget((GuiEventListener)this.partnerIdEditBox);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        this.enableConfigScreenTickButton = new TickBoxConfigComponent(new BooleanHolder(GlobalConfigs.packEditMode), splitWidth / 2 - 10, this.height - 55, 20, 20);
        this.addRenderableWidget((GuiEventListener)this.enableConfigScreenTickButton);
        Button closeButton = Button.builder((Component)CLOSE_TEXT, btn -> this.onClose()).pos((splitWidth - buttonWidth) / 2, this.height - 28).width(buttonWidth).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.width * 0.3f);
        int buttonWidth = Math.min(splitWidth - 20, 160);
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, MOD_TEXT, this.width / 2, 10, 0xFFFFFF);
        graphics.drawCenteredString(this.font, FEATURES_TEXT, (this.width + splitWidth) / 2, 30, 0xFFFFFF);
        graphics.drawCenteredString(this.font, PACK_ID_TEXT, splitWidth / 2, 60, 0xFFFFFF);
        graphics.drawCenteredString(this.font, PARTNER_ID_TEXT, splitWidth / 2, 110, 0xFFFFFF);
        int n = splitWidth / 2;
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, PACK_EDIT_MODE_TEXT, n, this.height - 57 - 9, 0xFFFFFF);
    }

    public void onClose() {
        this.packIdEditBox.save();
        this.partnerIdEditBox.save();
        this.enableConfigScreenTickButton.save();
        this.moduleSelectionList.saveAll();
        if (hasChanged) {
            GlobalConfigs.reloadConfigs();
            hasChanged = false;
        }
        this.minecraft.setScreen(this.parent);
    }
}

