/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class JarGroupListWidget
extends ObjectSelectionList<JarGroupEntry> {
    private final SelectJarStep parent;

    public JarGroupListWidget(SelectJarStep parent, Minecraft mc, int width, int height, int top, List<JarGroupData> groups) {
        Objects.requireNonNull(mc.font);
        super(mc, width, height, top, 9 * 2 + 8);
        this.parent = parent;
        for (JarGroupData group : groups) {
            this.addEntry((AbstractSelectionList.Entry)new JarGroupEntry(mc, group));
        }
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 6;
    }

    public class JarGroupEntry
    extends ObjectSelectionList.Entry<JarGroupEntry> {
        private final Minecraft mc;
        public final JarGroupData data;

        public JarGroupEntry(Minecraft mc, JarGroupData data) {
            this.mc = mc;
            this.data = data;
        }

        public void render(GuiGraphics graphics, int entry, int top, int left, int width, int unused, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = this.mc.font;
            int entryHeight = JarGroupListWidget.this.itemHeight;
            Objects.requireNonNull(font);
            int lineHeight = 9;
            int x = left + (width - font.width(this.data.name)) / 2;
            int y = top + (entryHeight - lineHeight) / 2 - 2;
            graphics.drawString(font, this.data.name, x, y, 0xFFFFFF);
            if (this.data.iconId != null) {
                NativeImage pixels = this.data.icon.getPixels();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float aspectRatio = (float)pixels.getWidth() / (float)pixels.getHeight();
                int iconHeight = entryHeight - 10;
                int iconWidth = (int)((float)iconHeight * aspectRatio);
                graphics.blit(this.data.iconId, x - iconWidth - 8, top + (entryHeight - 4 - iconHeight) / 2, 0, 0.0f, 0.0f, iconWidth, iconHeight, iconWidth, iconHeight);
            }
        }

        public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
            JarGroupListWidget.this.parent.setSelectedGroup(this);
            JarGroupListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public Component getNarration() {
            return Component.literal((String)this.data.name);
        }
    }
}

