/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.crabclaws;

import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.foxgirl.crabclaws.CrabClawItem;
import dev.foxgirl.crabclaws.CrabclawsConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrabclawsImpl {
    public static final Logger LOGGER = LogManager.getLogger();
    private static CrabclawsImpl INSTANCE = null;
    public final CrabclawsConfig config;
    public final DeferredRegister<Item> itemRegister;
    public final RegistrySupplier<CrabClawItem> crabClawItem;
    public final AttributeModifier reachAttributeModifier;
    protected static final ResourceLocation UNDERWATER_RUIN_SMALL = ResourceLocation.parse((String)"minecraft:chests/underwater_ruin_small");
    protected static final ResourceLocation UNDERWATER_RUIN_BIG = ResourceLocation.parse((String)"minecraft:chests/underwater_ruin_big");

    public static CrabclawsImpl getInstance() {
        return INSTANCE;
    }

    public CrabclawsImpl() {
        INSTANCE = this;
        this.config = CrabclawsConfig.loadConfig();
        this.itemRegister = DeferredRegister.create((String)"crabclaws", (ResourceKey)Registries.ITEM);
        this.crabClawItem = this.itemRegister.register("crab_claw", CrabClawItem::new);
        this.reachAttributeModifier = new AttributeModifier(ResourceLocation.parse((String)"crabclaws:extra_reach"), this.config.clawExtraReachAmount, AttributeModifier.Operation.ADD_VALUE);
        TickEvent.PLAYER_POST.register(this::onPlayerPost);
        LootEvent.MODIFY_LOOT_TABLE.register(this::onModifyLootTable);
        this.itemRegister.register();
    }

    public CrabClawItem getCrabClawItem() {
        return (CrabClawItem)((Object)this.crabClawItem.get());
    }

    protected void onPlayerPost(Player player) {
        AttributeInstance attribute = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (attribute == null) {
            return;
        }
        if (player.getMainHandItem().getItem() == this.getCrabClawItem() || player.getOffhandItem().getItem() == this.getCrabClawItem()) {
            if (!attribute.hasModifier(this.reachAttributeModifier.id())) {
                attribute.addTransientModifier(this.reachAttributeModifier);
            }
        } else if (attribute.hasModifier(this.reachAttributeModifier.id())) {
            attribute.removeModifier(this.reachAttributeModifier.id());
        }
    }

    protected void onModifyLootTable(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context, boolean isBuiltin) {
        if (this.config.shouldSpawnClawsInRuins && (key.location().equals((Object)UNDERWATER_RUIN_SMALL) || key.location().equals((Object)UNDERWATER_RUIN_BIG))) {
            context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(this.config.probabilityOfClawsInRuins)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.getCrabClawItem()).setWeight(1)));
        }
    }
}

