/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.init.ModTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DeadCoralPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public DeadCoralPatchFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        for (int j = 0; j < 64; ++j) {
            BlockPos blockpos = pos.offset(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)blockpos) || !world.getBlockState(blockpos.below()).is(ModTags.Blocks.TIDEPOOL_REPLACEABLE)) continue;
            world.setBlock(blockpos, (BlockState)(switch (rand.nextInt(10)) {
                default -> Blocks.DEAD_TUBE_CORAL.defaultBlockState();
                case 1 -> Blocks.DEAD_BRAIN_CORAL.defaultBlockState();
                case 2 -> Blocks.DEAD_BUBBLE_CORAL.defaultBlockState();
                case 3 -> Blocks.DEAD_FIRE_CORAL.defaultBlockState();
                case 4 -> Blocks.DEAD_HORN_CORAL.defaultBlockState();
                case 5 -> Blocks.DEAD_TUBE_CORAL_FAN.defaultBlockState();
                case 6 -> Blocks.DEAD_BRAIN_CORAL_FAN.defaultBlockState();
                case 7 -> Blocks.DEAD_BUBBLE_CORAL_FAN.defaultBlockState();
                case 8 -> Blocks.DEAD_FIRE_CORAL_FAN.defaultBlockState();
                case 9 -> Blocks.DEAD_HORN_CORAL_FAN.defaultBlockState();
            }).setValue((Property)BaseCoralPlantTypeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
            ++i;
        }
        return i > 0;
    }
}

