/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.livingthings.client.LivingThingsClient;
import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.model.entity.CrabModel;
import com.tristankechlo.livingthings.entity.CrabEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrabRenderer
extends MobRenderer<CrabEntity, CrabModel<CrabEntity>> {
    protected static final ResourceLocation TEXTURE_WHITE = LivingThingsClient.getEntityTexture("crab/crab_white.png");
    protected static final ResourceLocation TEXTURE_RED = LivingThingsClient.getEntityTexture("crab/crab_red.png");
    protected static final ResourceLocation TEXTURE_BLUE = LivingThingsClient.getEntityTexture("crab/crab_blue.png");

    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, new CrabModel(context.bakeLayer(ModelLayer.CRAB)), 0.4f);
    }

    public ResourceLocation getTextureLocation(CrabEntity entity) {
        byte variant = entity.getVariant();
        if (variant == 2) {
            return TEXTURE_BLUE;
        }
        if (variant == 1) {
            return TEXTURE_WHITE;
        }
        return TEXTURE_RED;
    }

    protected void scale(CrabEntity crab, PoseStack matrixStackIn, float partialTickTime) {
        if (!crab.isBaby()) {
            float scale = 1.0f + (float)crab.getScaling() * 0.1f;
            matrixStackIn.scale(scale, scale, scale);
        }
        matrixStackIn.translate(0.0, 0.01, 0.0);
        super.scale((LivingEntity)crab, matrixStackIn, partialTickTime);
    }
}

