/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.RaccoonConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.ai.BreakOstrichEggGoal;
import com.tristankechlo.livingthings.entity.ai.BreakTurtleEggGoal;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RaccoonEntity
extends Animal
implements NeutralMob,
ILexiconEntry {
    private static final UniformInt rangedInteger = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public RaccoonEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean checkRaccoonSpawnRules(EntityType<RaccoonEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.RACCOON_SPAWNABLE_ON) && RaccoonEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntityTypes.RACCOON.get().create((Level)world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, RaccoonConfig.health()).add(Attributes.MOVEMENT_SPEED, RaccoonConfig.movementSpeed()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, RaccoonConfig.attackDamage());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.25, false, RaccoonConfig::canAttack));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredients.RACCOON_FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new BreakOstrichEggGoal((PathfinderMob)this, 1.0, 3, 100, false));
        this.goalSelector.addGoal(5, (Goal)new BreakTurtleEggGoal((PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.RACCOON_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.RACCOON_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return ModSounds.RACCOON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.RACCOON_DEATH.get();
    }

    public int getAmbientSoundInterval() {
        return 300;
    }

    public int getMaxSpawnClusterSize() {
        return RaccoonConfig.maxSpawnedInChunk();
    }

    protected int calculateFallDamage(float distance, float damageMultiplier) {
        return super.calculateFallDamage(distance, damageMultiplier * 0.3f);
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(rangedInteger.sample(this.random));
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.RACCOON;
    }
}

