/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity.misc;

import java.util.ArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.AgeableMob;

public interface IMobVariants {
    public byte getVariant();

    public void setVariant(byte var1);

    default public byte getVariantFromParents(AgeableMob entity1, AgeableMob entity2) {
        if (entity1 instanceof IMobVariants && entity2 instanceof IMobVariants) {
            byte parent2;
            byte parent1 = ((IMobVariants)entity1).getVariant();
            if (parent1 == (parent2 = ((IMobVariants)entity2).getVariant())) {
                return parent1;
            }
            if (entity1.getRandom().nextBoolean()) {
                return parent1;
            }
            return parent2;
        }
        return 0;
    }

    default public byte getRandomVariant(RandomSource random, byte[] variants, int[] weights) {
        if (weights.length != variants.length) {
            throw new IllegalArgumentException("Weights and Variants must have the same length.");
        }
        if (weights.length <= 0 || weights.length > 127) {
            return 0;
        }
        ArrayList<WeightedMobVariant> weightedList = new ArrayList<WeightedMobVariant>();
        for (int i = 0; i < weights.length; ++i) {
            if (weights[i] <= 0 || variants[i] < 0) continue;
            weightedList.add(new WeightedMobVariant(weights[i], variants[i]));
        }
        return ((WeightedMobVariant)WeightedRandom.getRandomItem((RandomSource)random, weightedList).get()).variant;
    }

    public static class WeightedMobVariant
    implements WeightedEntry {
        public final byte variant;
        public final Weight weight;

        public WeightedMobVariant(int weight, byte variant) {
            this.variant = variant;
            this.weight = Weight.of((int)weight);
        }

        public Weight getWeight() {
            return this.weight;
        }
    }
}

