/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.wider_ender_chests.shared;

import com.craftix.wider_ender_chests.shared.ChestType;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CustomChestMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;
    final ChestType chestType;

    public CustomChestMenu(ChestType type, int i, Inventory inventory, Supplier<MenuType<CustomChestMenu>> menuType) {
        this(type, i, inventory, (Container)new SimpleContainer(9 * (type.getExtraSlots() + 3)), type.getExtraSlots() + 3, menuType);
    }

    public CustomChestMenu(ChestType type, int containerId, Inventory inventory, Container container, int rows, Supplier<MenuType<CustomChestMenu>> menuType) {
        super(menuType.get(), containerId);
        int m;
        int l;
        CustomChestMenu.checkContainerSize((Container)container, (int)(rows * 9));
        this.container = container;
        this.containerRows = rows;
        int maxSlots = 72;
        this.chestType = type;
        container.startOpen(inventory.player);
        int k = (this.containerRows - 4) * 18;
        for (l = 0; l < this.containerRows; ++l) {
            for (m = 0; m < 9; ++m) {
                this.addSlot(new Slot(container, m + l * 9, 8 + m * 18, 18 + l * 18 - 2));
            }
        }
        for (l = 0; l < 3; ++l) {
            for (m = 0; m < 9; ++m) {
                this.addSlot(new Slot((Container)inventory, m + l * 9 + 9, 8 + m * 18, 103 + l * 18 + maxSlots - 1));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)inventory, l, 8 + l * 18, 161 + maxSlots - 1));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (i < this.containerRows * 9 ? !this.moveItemStackTo(itemStack2, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public Container getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }
}

