/*
 * Decompiled with CFR 0.152.
 */
package com.craftix.wider_ender_chests.shared;

import com.craftix.wider_ender_chests.shared.ChestType;
import com.craftix.wider_ender_chests.shared.CustomChestMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CustomEnderChestBlock
extends EnderChestBlock {
    public ChestType type;
    public Supplier<MenuType<CustomChestMenu>> menu;

    public CustomEnderChestBlock(BlockBehaviour.Properties properties, ChestType type, Supplier<MenuType<CustomChestMenu>> menu) {
        super(properties);
        this.type = type;
        this.menu = menu;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        PlayerEnderChestContainer playerEnderChestContainer = player.getEnderChestInventory();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (playerEnderChestContainer != null && blockEntity instanceof EnderChestBlockEntity) {
            BlockPos blockPos2 = blockPos.above();
            if (level.getBlockState(blockPos2).isRedstoneConductor((BlockGetter)level, blockPos2)) {
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            EnderChestBlockEntity enderChestBlockEntity = (EnderChestBlockEntity)blockEntity;
            playerEnderChestContainer.setActiveChest(enderChestBlockEntity);
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, playerx) -> new CustomChestMenu(this.type, i, inventory, (Container)playerEnderChestContainer, 3 + this.type.getExtraSlots(), () -> this.menu.get()), (Component)Component.translatable((String)("container.enderchest." + this.type.name().toLowerCase()))));
            player.awardStat(Stats.OPEN_ENDERCHEST);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? CustomEnderChestBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityType.ENDER_CHEST, EnderChestBlockEntity::lidAnimateTick) : null;
    }
}

