/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block.entity;

import com.starfish_studios.another_furniture.registry.AFBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShelfBlockEntity
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);

    public ShelfBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(AFBlockEntityTypes.SHELF.get(), blockPos, blockState);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundtag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        return compoundtag;
    }

    public boolean placeItem(ItemStack stack, int position) {
        ItemStack itemstack = (ItemStack)this.items.get(position);
        if (!itemstack.isEmpty()) {
            return false;
        }
        this.items.set(position, (Object)stack.split(stack.getCount()));
        this.markUpdated();
        return true;
    }

    public boolean removeItem(int index, Player player, Level level) {
        if (((ItemStack)this.items.get(index)).isEmpty()) {
            return false;
        }
        if (level.isClientSide()) {
            player.playSound(SoundEvents.ITEM_PICKUP);
            return true;
        }
        ItemStack item = ((ItemStack)this.items.get(index)).copy();
        player.setItemSlot(EquipmentSlot.MAINHAND, item);
        this.items.set(index, (Object)ItemStack.EMPTY);
        this.markUpdated();
        return true;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void removeAllItems() {
        boolean update = false;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            double posX = (double)this.worldPosition.getX() + 0.3 + 0.4 * (double)(i % 2);
            double posY = (double)this.worldPosition.getY() + 1.0;
            double posZ = (double)this.worldPosition.getZ() + 0.3 + 0.4 * (double)(i / 2);
            ItemEntity entity = new ItemEntity(this.level, posX, posY + 0.1, posZ, ((ItemStack)this.items.get(i)).copy());
            this.level.addFreshEntity((Entity)entity);
            this.items.set(i, (Object)ItemStack.EMPTY);
            update = true;
        }
        if (update) {
            this.markUpdated();
        }
    }
}

