/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.components.item.KeyringContents;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class KeyringRecipe
extends ShapedRecipe {
    public KeyringRecipe(CraftingBookCategory cat) {
        super("", cat, new ShapedRecipePattern(3, 3, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_NUGGET}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_NUGGET}), Ingredient.of(ModItems.getKeys().map(i -> new ItemStack((ItemLike)i, 1))), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_NUGGET}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_NUGGET}), Ingredient.EMPTY}), Optional.empty()), new ItemStack((ItemLike)ModItems.KEYRING.get()));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack center = inv.getItem(4);
        if (center.isEmpty() || !(center.getItem() instanceof ItemKey)) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemKeyring.getKeyring(center);
        if (result.isEmpty()) {
            return ItemStack.EMPTY;
        }
        KeyringContents contents = (KeyringContents)result.get((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get());
        if (contents == null) {
            contents = new KeyringContents(new ArrayList<ItemStack>());
        }
        KeyringContents.Mutable mutable = new KeyringContents.Mutable(contents);
        mutable.tryInsert(center.copy());
        result.set((DataComponentType)ModDataComponents.KEYRING_CONTENTS.get(), (Object)mutable.toImmutable());
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.KEYRING_RECIPE_SERIALIZER.get();
    }
}

