/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BackpackDynamicModel
implements IUnbakedGeometry<BackpackDynamicModel> {
    private final Map<ModelParts, UnbakedModel> modelParts;
    private final ResourceLocation renderType;

    private BackpackDynamicModel(Map<ModelParts, UnbakedModel> modelParts, @Nullable ResourceLocation renderType) {
        this.modelParts = modelParts;
        this.renderType = renderType;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RenderTypeGroup renderTypes = this.renderType != null ? context.getRenderType(this.renderType) : RenderTypeGroup.EMPTY;
        this.modelParts.forEach((part, model) -> {
            BakedModel bakedModel = model.bake(baker, spriteGetter, modelTransform);
            if (bakedModel != null) {
                builder.put((Object)part, (Object)bakedModel);
            }
        });
        return new BackpackBakedModel((Map<ModelParts, BakedModel>)builder.build(), modelTransform, renderTypes);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.modelParts.values().forEach(model -> model.resolveParents(modelGetter));
    }

    private static final class BackpackBakedModel
    implements IDynamicBakedModel {
        public static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final ItemTransforms ITEM_TRANSFORMS = BackpackBakedModel.createItemTransforms();
        private final BackpackItemOverrideList overrideList = new BackpackItemOverrideList(this);
        private final Map<ModelParts, BakedModel> models;
        private final ModelState modelTransform;
        private final ChunkRenderTypeSet blockRenderTypes;
        private final List<RenderType> itemRenderTypes;
        private final List<RenderType> fabulousItemRenderTypes;
        private boolean isDyed;
        private boolean isSleepingBagDeployed;
        private int sleepingBagColor;
        private RenderInfo renderInfo;
        private Block block;

        private static ItemTransforms createItemTransforms() {
            return new ItemTransforms(new ItemTransform(new Vector3f(60.0f, -180.0f, 0.0f), new Vector3f(0.0f, 0.09375f, 0.03125f), new Vector3f(0.7f, 0.7f, 0.7f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(60.0f, -180.0f, 0.0f), new Vector3f(0.0f, 0.09375f, 0.03125f), new Vector3f(0.7f, 0.7f, 0.7f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, -90.0f, 12.5f), new Vector3f(0.070625f, 0.375f, 0.125f), new Vector3f(0.68f, 0.68f, 0.68f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, -90.0f, 12.5f), new Vector3f(0.070625f, 0.375f, 0.125f), new Vector3f(0.68f, 0.68f, 0.68f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.90625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(30.0f, -38.0f, 0.0f), new Vector3f(-0.015625f, 0.140625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.125f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 180.0f, 0.0f), new Vector3f(0.0f, 0.140625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), DEFAULT_ROTATION), ImmutableMap.of());
        }

        public BackpackBakedModel(Map<ModelParts, BakedModel> models, ModelState modelTransform, RenderTypeGroup renderTypes) {
            this.models = models;
            this.modelTransform = modelTransform;
            boolean hasRenderTypes = renderTypes != null && !renderTypes.isEmpty();
            this.blockRenderTypes = hasRenderTypes ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderTypes.block()}) : null;
            this.itemRenderTypes = hasRenderTypes ? List.of(renderTypes.entity()) : null;
            this.fabulousItemRenderTypes = hasRenderTypes ? List.of(renderTypes.entityFabulous()) : null;
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            if (this.blockRenderTypes != null) {
                return this.blockRenderTypes;
            }
            return ItemBlockRenderTypes.getRenderLayers((BlockState)state);
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            if (!fabulous) {
                if (this.itemRenderTypes != null) {
                    return this.itemRenderTypes;
                }
            } else if (this.fabulousItemRenderTypes != null) {
                return this.fabulousItemRenderTypes;
            }
            return List.of(RenderTypeHelper.getFallbackItemRenderType((ItemStack)itemStack, (BakedModel)this, (boolean)fabulous));
        }

        @Nonnull
        public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
            if (state != null) {
                this.block = state.getBlock();
                this.isDyed = extraData.has(BackpackBlockEntity.DYE_COLOR);
                this.renderInfo = extraData.has(BackpackBlockEntity.RENDER_INFO) ? (RenderInfo)extraData.get(BackpackBlockEntity.RENDER_INFO) : RenderInfo.EMPTY;
                this.sleepingBagColor = extraData.has(BackpackBlockEntity.SLEEPING_BAG_COLOR) ? ((Integer)extraData.get(BackpackBlockEntity.SLEEPING_BAG_COLOR)).intValue() : DyeColor.RED.getId();
                boolean bl = this.isSleepingBagDeployed = extraData.has(BackpackBlockEntity.SLEEPING_BAG_DEPLOYED) ? (Boolean)extraData.get(BackpackBlockEntity.SLEEPING_BAG_DEPLOYED) : false;
            }
            if (this.isDyed && this.block == ModBlocks.STANDARD_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.BASE_DYED).getQuads(state, side, rand, extraData, renderType));
                ret.addAll(this.models.get((Object)ModelParts.EXTRAS).getQuads(state, side, rand, extraData, renderType));
            } else {
                ret.addAll(this.models.get((Object)ModelParts.BASE).getQuads(state, side, rand, extraData, renderType));
            }
            if (this.renderInfo == null || !this.renderInfo.isEmpty()) {
                this.addTanks(state, side, rand, extraData, ret, renderType);
            }
            if (!this.isSleepingBagDeployed) {
                this.addSleepingBag(ret, state, side, rand, extraData, renderType);
            }
            this.addExtras(ret, state, side, rand, extraData, renderType);
            return ret;
        }

        private void addFluids(List<BakedQuad> ret, RenderInfo renderInfo) {
            if (renderInfo != null && !renderInfo.isEmpty()) {
                if (!renderInfo.getLeftFluidStack().isEmpty()) {
                    this.addFluid(ret, renderInfo.getLeftFluidStack(), (float)renderInfo.getLeftFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.1125f);
                }
                if (!renderInfo.getRightFluidStack().isEmpty()) {
                    this.addFluid(ret, renderInfo.getRightFluidStack(), (float)renderInfo.getRightFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.79375f);
                }
            }
        }

        private void addSleepingBag(List<BakedQuad> ret, BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            ret.addAll(this.models.get((Object)ModelParts.SLEEPING_BAG_EXTRAS).getQuads(state, side, rand, extraData, renderType));
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("block/bag/" + DyeColor.byId((int)this.sleepingBagColor).getName().toLowerCase(Locale.ENGLISH) + "_sleeping_bag")));
            this.rebakeSleepingBag(ret, sprite, state, side, rand, extraData, renderType);
        }

        private void rebakeSleepingBag(List<BakedQuad> ret, TextureAtlasSprite sprite, BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            this.models.get((Object)ModelParts.SLEEPING_BAG).getQuads(state, side, rand, extraData, renderType).forEach(quad -> {
                TextureAtlasSprite oldSprite = quad.getSprite();
                int[] oldData = quad.getVertices();
                int[] newData = Arrays.copyOf(oldData, oldData.length);
                for (int i = 0; i < 4; ++i) {
                    int index = i * 8;
                    float oldU = Float.intBitsToFloat(oldData[index + 4]);
                    float oldV = Float.intBitsToFloat(oldData[index + 5]);
                    float uUn = oldSprite.getUOffset(oldU);
                    float vUn = oldSprite.getVOffset(oldV);
                    float newU = sprite.getU(uUn);
                    float newV = sprite.getV(vUn);
                    newData[index + 4] = Float.floatToRawIntBits(newU);
                    newData[index + 5] = Float.floatToRawIntBits(newV);
                    ret.add(new BakedQuad(newData, quad.getTintIndex(), quad.getDirection(), sprite, quad.isShade(), quad.hasAmbientOcclusion()));
                }
            });
        }

        private void addExtras(List<BakedQuad> ret, BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
            if (this.block == ModBlocks.FOX_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.FOX_NOSE).getQuads(state, side, rand, extraData, renderType));
            }
            if (this.block == ModBlocks.WARDEN_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.WARDEN_HORNS).getQuads(state, side, rand, extraData, renderType));
            }
            if (this.block == ModBlocks.WOLF_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.WOLF_NOSE).getQuads(state, side, rand, extraData, renderType));
            }
            if (this.block == ModBlocks.OCELOT_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.OCELOT_NOSE).getQuads(state, side, rand, extraData, renderType));
            }
            if (this.block == ModBlocks.PIG_TRAVELERS_BACKPACK.get() || this.block == ModBlocks.HORSE_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.PIG_NOSE).getQuads(state, side, rand, extraData, renderType));
            }
            if (this.block == ModBlocks.VILLAGER_TRAVELERS_BACKPACK.get() || this.block == ModBlocks.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                ret.addAll(this.models.get((Object)ModelParts.VILLAGER_NOSE).getQuads(state, side, rand, extraData, renderType));
            }
        }

        private void addTanks(BlockState state, Direction side, RandomSource rand, ModelData extraData, List<BakedQuad> ret, RenderType renderType) {
            ret.addAll(this.models.get((Object)ModelParts.TANKS).getQuads(state, side, rand, extraData, renderType));
            this.addFluids(ret, this.renderInfo);
        }

        private void addFluid(List<BakedQuad> ret, FluidStack fluidStack, float ratio, double xMin) {
            if (fluidStack.isEmpty()) {
                return;
            }
            double yMin = 0.05;
            double yMax = yMin + (double)ratio * 6.2 / 16.0;
            AABB bounds = new AABB(xMin, yMin, 0.39375, xMin + 0.09375, yMax, 0.4875);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation stillTexture = renderProperties.getStillTexture(fluidStack);
            int color = renderProperties.getTintColor(fluidStack) | 0xFF000000;
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
            float x1 = 0.0f;
            float x2 = 3.0f;
            float y1 = 0.0f;
            float y2 = ratio * 12.0f;
            float z1 = 0.0f;
            float z2 = 3.0f;
            ret.add(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.minZ), this.getVector(bounds.minX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.minZ)), still, Direction.UP, false, color, x1, x2, z1, z2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.maxX, bounds.maxY, bounds.minZ), this.getVector(bounds.maxX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.maxY, bounds.minZ)), still, Direction.NORTH, false, color, x1, x2, y1, y2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.maxZ), this.getVector(bounds.minX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ)), still, Direction.SOUTH, false, color, x1, x2, y1, y2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.maxZ), this.getVector(bounds.minX, bounds.maxY, bounds.maxZ)), still, Direction.WEST, false, color, z1, z2, y1, y2));
            ret.add(this.createQuad(List.of(this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.minZ), this.getVector(bounds.maxX, bounds.maxY, bounds.minZ)), still, Direction.EAST, false, color, z1, z2, y1, y2));
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return true;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.models.get((Object)ModelParts.BASE).getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return this.overrideList;
        }

        public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            if (transformType == ItemDisplayContext.NONE) {
                return this;
            }
            ITEM_TRANSFORMS.getTransform(transformType).apply(applyLeftHandTransform, poseStack);
            return this;
        }

        public ItemTransforms getTransforms() {
            return ITEM_TRANSFORMS;
        }

        private BakedQuad createQuad(List<Vector3f> vectors, TextureAtlasSprite sprite, Direction face, boolean hasAmbientOcclusion, int color, float u1x, float u2x, float v1x, float v2x) {
            QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer();
            quadBaker.setSprite(sprite);
            Vec3i dirVec = face.getNormal();
            quadBaker.setDirection(face);
            quadBaker.setTintIndex(-1);
            quadBaker.setShade(true);
            quadBaker.setHasAmbientOcclusion(hasAmbientOcclusion);
            float u1 = sprite.getU(u1x /= 16.0f);
            float u2 = sprite.getU(u2x /= 16.0f);
            float v1 = sprite.getV(v1x /= 16.0f);
            float v2 = sprite.getV(v2x /= 16.0f);
            quadBaker.addVertex(vectors.get(0).x(), vectors.get(0).y(), vectors.get(0).z()).setColor(color).setUv(u1, v1).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vectors.get(1).x(), vectors.get(1).y(), vectors.get(1).z()).setColor(color).setUv(u1, v2).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vectors.get(2).x(), vectors.get(2).y(), vectors.get(2).z()).setColor(color).setUv(u2, v2).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vectors.get(3).x(), vectors.get(3).y(), vectors.get(3).z()).setColor(color).setUv(u2, v1).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            return quadBaker.bakeQuad();
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelTransform.getRotation().getMatrix());
            return ret;
        }

        private void rotate(Vector3f posIn, Matrix4f transform) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0f));
            posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
        }
    }

    private static enum ModelParts {
        BASE,
        BASE_DYED,
        EXTRAS,
        TANKS,
        SLEEPING_BAG,
        SLEEPING_BAG_EXTRAS,
        FOX_NOSE,
        OCELOT_NOSE,
        WOLF_NOSE,
        VILLAGER_NOSE,
        PIG_NOSE,
        WARDEN_HORNS;

    }

    public static final class Loader
    implements IGeometryLoader<BackpackDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public BackpackDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ResourceLocation res;
            ResourceLocation particleTexture;
            ResourceLocation backpackTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder texturesBuilder = ImmutableMap.builder();
            ResourceLocation renderType = null;
            if (modelContents.has("backpackTexture") && (backpackTexture = ResourceLocation.tryParse((String)modelContents.get("backpackTexture").getAsString())) != null) {
                texturesBuilder.put((Object)"0", (Object)Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, backpackTexture)));
            }
            if (modelContents.has("particle") && (particleTexture = ResourceLocation.tryParse((String)modelContents.get("particle").getAsString())) != null) {
                texturesBuilder.put((Object)"particle", (Object)Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, particleTexture)));
            }
            if (modelContents.has("render_type") && (res = ResourceLocation.tryParse((String)modelContents.get("render_type").getAsString())) != null) {
                renderType = res;
            }
            ImmutableMap textures = texturesBuilder.build();
            for (ModelParts part : ModelParts.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelParts, UnbakedModel>)builder, part, (ImmutableMap<String, Either<Material, String>>)textures);
            }
            return new BackpackDynamicModel((Map<ModelParts, UnbakedModel>)builder.build(), renderType);
        }

        private void addPartModel(ImmutableMap.Builder<ModelParts, UnbakedModel> builder, ModelParts modelPart, ImmutableMap<String, Either<Material, String>> textures) {
            builder.put((Object)modelPart, (Object)new BlockModel(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH))), Collections.emptyList(), textures, Boolean.valueOf(true), null, ItemTransforms.NO_TRANSFORMS, Collections.emptyList()));
        }
    }

    private static class BackpackItemOverrideList
    extends ItemOverrides {
        private final BackpackBakedModel backpackModel;

        public BackpackItemOverrideList(BackpackBakedModel backpackModel) {
            this.backpackModel = backpackModel;
        }

        public BakedModel resolve(BakedModel model, ItemStack stack, ClientLevel world, LivingEntity livingEntity, int seed) {
            this.backpackModel.isDyed = stack.has(DataComponents.DYED_COLOR);
            this.backpackModel.renderInfo = (RenderInfo)stack.get(ModDataComponents.RENDER_INFO);
            this.backpackModel.sleepingBagColor = (Integer)stack.getOrDefault(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.RED.getId());
            this.backpackModel.isSleepingBagDeployed = false;
            this.backpackModel.block = Block.byItem((Item)stack.getItem());
            return this.backpackModel;
        }
    }
}

