/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.effect;

import com.soytutta.mynethersdelight.common.effect.AbstractPungentEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class PungentEffect
extends AbstractPungentEffect {
    public PungentEffect() {
        super(MobEffectCategory.HARMFUL, 9127187);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        this.switchEffect(entity);
        if (this.isInFireCondition(entity) || entity.isInLava() || entity.isOnFire()) {
            float minHealth;
            float f = amplifier >= 2 ? 2.0f : (minHealth = amplifier == 1 ? entity.getMaxHealth() / 2.0f : entity.getMaxHealth() - entity.getMaxHealth() / 4.0f);
            if (entity.getHealth() > minHealth) {
                entity.hurt(entity.damageSources().magic(), 1.0f);
                entity.setRemainingFireTicks(10);
            } else if (entity.isOnFire()) {
                entity.setRemainingFireTicks(0);
                entity.clearFire();
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 25 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

