/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.mixin;

import com.soytutta.mynethersdelight.common.utility.EntityDropChanceAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements EntityDropChanceAccessor {
    @Shadow
    protected abstract void dropAllDeathLoot(ServerLevel var1, DamageSource var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemStack> callGenerateLoot(DamageSource damageSource) {
        LivingEntity self = (LivingEntity)this;
        Level level = self.level();
        if (!(level instanceof ServerLevel)) {
            return new ArrayList<ItemStack>();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Collection capturedDrops = self.captureDrops(new ArrayList());
        try {
            this.dropAllDeathLoot(serverLevel, damageSource);
        }
        finally {
            capturedDrops = self.captureDrops(capturedDrops);
        }
        if (capturedDrops != null) {
            return capturedDrops.stream().map(ItemEntity::getItem).collect(Collectors.toList());
        }
        return new ArrayList<ItemStack>();
    }
}

