/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_useful_copper.core.entity.goal;

import common.com.cursee.more_useful_copper.core.entity.CopperGolem;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class DefendPlayerTargetGoal
extends TargetGoal {
    private final CopperGolem golem;
    @Nullable
    private LivingEntity potentialTarget;
    private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);

    public DefendPlayerTargetGoal(CopperGolem golem) {
        super((Mob)golem, false, true);
        this.golem = golem;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public void start() {
        this.golem.setTarget(this.potentialTarget);
        super.start();
    }

    public boolean canUse() {
        block6: {
            block5: {
                AABB golemBoundingBox = this.golem.getBoundingBox().inflate(10.0, 8.0, 10.0);
                List playersNearby = this.golem.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)this.golem, golemBoundingBox);
                for (Player player : playersNearby) {
                    LivingEntity lastAttacker = player.getLastAttacker() == null ? player.getLastAttacker() : null;
                    if (lastAttacker == null || !lastAttacker.isDeadOrDying()) continue;
                    this.potentialTarget = lastAttacker;
                }
                if (this.potentialTarget == null) {
                    return false;
                }
                LivingEntity livingEntity = this.potentialTarget;
                if (!(livingEntity instanceof Player)) break block5;
                Player player = (Player)livingEntity;
                if (this.potentialTarget.isSpectator() || player.isCreative()) break block6;
            }
            return true;
        }
        return false;
    }
}

