/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_useful_copper.core.item.custom;

import common.com.cursee.more_useful_copper.platform.Services;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class CopperBucketItem
extends Item
implements DispensibleContainerItem {
    private final Fluid content;

    public CopperBucketItem(Fluid fluid, Item.Properties properties) {
        super(properties);
        this.content = fluid;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pInteractionHand) {
        ItemStack vItemStack = pPlayer.getItemInHand(pInteractionHand);
        BlockHitResult vBlockHitResult = CopperBucketItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (vBlockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)vItemStack);
        }
        if (vBlockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)vItemStack);
        }
        BlockPos vBlockPos = vBlockHitResult.getBlockPos();
        Direction vDirection = vBlockHitResult.getDirection();
        BlockPos vBlockPos1 = vBlockPos.relative(vDirection);
        if (pLevel.mayInteract(pPlayer, vBlockPos) && pPlayer.mayUseItemAt(vBlockPos1, vDirection, vItemStack)) {
            if (this.content == Fluids.EMPTY) {
                BlockState vBlockState = pLevel.getBlockState(vBlockPos);
                ItemStack full = Services.PLATFORM.getWaterCopperBucketItem().getDefaultInstance();
                if (vBlockState.getBlock() == Blocks.WATER_CAULDRON) {
                    if (vItemStack.getCount() > 1) {
                        vItemStack.setCount(vItemStack.getCount() - 1);
                        pPlayer.setItemInHand(pInteractionHand, vItemStack);
                        pPlayer.addItem(full);
                        pLevel.setBlock(vBlockPos, Blocks.CAULDRON.defaultBlockState(), 3);
                        return InteractionResultHolder.sidedSuccess((Object)vItemStack, (boolean)pLevel.isClientSide());
                    }
                    pPlayer.setItemInHand(pInteractionHand, full);
                    pLevel.setBlock(vBlockPos, Blocks.CAULDRON.defaultBlockState(), 3);
                    return InteractionResultHolder.sidedSuccess((Object)full, (boolean)pLevel.isClientSide());
                }
                ItemStack filled = Services.PLATFORM.getSnowCopperBucketItem().getDefaultInstance();
                if (vBlockState.getBlock() == Blocks.POWDER_SNOW) {
                    if (vItemStack.getCount() > 1) {
                        vItemStack.setCount(vItemStack.getCount() - 1);
                        pPlayer.setItemInHand(pInteractionHand, vItemStack);
                        pPlayer.addItem(filled);
                        pLevel.setBlock(vBlockPos, Blocks.AIR.defaultBlockState(), 3);
                        return InteractionResultHolder.sidedSuccess((Object)vItemStack, (boolean)pLevel.isClientSide());
                    }
                    pPlayer.setItemInHand(pInteractionHand, filled);
                    pLevel.setBlock(vBlockPos, Blocks.AIR.defaultBlockState(), 3);
                    return InteractionResultHolder.sidedSuccess((Object)filled, (boolean)pLevel.isClientSide());
                }
                if (vBlockState.getBlock() instanceof BucketPickup && vBlockState.getBlock() != Blocks.LAVA && vBlockState.getBlock() != Blocks.LAVA_CAULDRON) {
                    BucketPickup vBucketPickup = (BucketPickup)vBlockState.getBlock();
                    ItemStack vItemStack1 = vBucketPickup.pickupBlock(pPlayer, (LevelAccessor)pLevel, vBlockPos, vBlockState);
                    if (vItemStack1.getItem() == Items.WATER_BUCKET) {
                        vItemStack1 = Services.PLATFORM.getWaterCopperBucketItem().getDefaultInstance();
                    }
                    if (!vItemStack1.isEmpty()) {
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
                        vBucketPickup.getPickupSound().ifPresent($$1x -> pPlayer.playSound($$1x, 1.0f, 1.0f));
                        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.FLUID_PICKUP, vBlockPos);
                        ItemStack vItemStack2 = ItemUtils.createFilledResult((ItemStack)vItemStack, (Player)pPlayer, (ItemStack)vItemStack1);
                        if (!pLevel.isClientSide) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)pPlayer, vItemStack1);
                        }
                        return InteractionResultHolder.sidedSuccess((Object)vItemStack2, (boolean)pLevel.isClientSide());
                    }
                }
            } else {
                BlockPos vBlockPos2;
                BlockState vBlockState = pLevel.getBlockState(vBlockPos);
                BlockPos blockPos = vBlockPos2 = vBlockState.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? vBlockPos : vBlockPos1;
                if (vBlockState.getBlock() == Blocks.CAULDRON) {
                    ItemStack empty = Services.PLATFORM.getEmptyCopperBucketItem().getDefaultInstance();
                    pPlayer.setItemInHand(pInteractionHand, empty);
                    pLevel.setBlock(vBlockPos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), 3);
                    return InteractionResultHolder.sidedSuccess((Object)empty, (boolean)pLevel.isClientSide());
                }
                if (this.emptyContents(pPlayer, pLevel, vBlockPos2, vBlockHitResult)) {
                    this.checkExtraContent(pPlayer, pLevel, vItemStack, vBlockPos2);
                    if (pPlayer instanceof ServerPlayer) {
                        CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)pPlayer, vBlockPos2, vItemStack);
                    }
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
                    return InteractionResultHolder.sidedSuccess((Object)CopperBucketItem.getEmptySuccessItem(vItemStack, pPlayer), (boolean)pLevel.isClientSide());
                }
                return InteractionResultHolder.fail((Object)vItemStack);
            }
        }
        return InteractionResultHolder.fail((Object)vItemStack);
    }

    public InteractionResultHolder<ItemStack> useOLD(Level pLevel, Player pPlayer, InteractionHand pInteractionHand) {
        ItemStack vItemStack = pPlayer.getItemInHand(pInteractionHand);
        BlockHitResult vBlockHitResult = CopperBucketItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (vBlockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)vItemStack);
        }
        if (vBlockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)vItemStack);
        }
        BlockPos vBlockPos = vBlockHitResult.getBlockPos();
        Direction vDirection = vBlockHitResult.getDirection();
        BlockPos vBlockPos1 = vBlockPos.relative(vDirection);
        if (pLevel.mayInteract(pPlayer, vBlockPos) && pPlayer.mayUseItemAt(vBlockPos1, vDirection, vItemStack)) {
            BlockPos vBlockPos2;
            if (this.content == Fluids.EMPTY) {
                BlockState vBlockState = pLevel.getBlockState(vBlockPos);
                Block block = vBlockState.getBlock();
                if (block instanceof BucketPickup && block == Blocks.WATER) {
                    BucketPickup vBucketPickup = (BucketPickup)vBlockState.getBlock();
                    ItemStack vItemStack1 = vBucketPickup.pickupBlock(pPlayer, (LevelAccessor)pLevel, vBlockPos, vBlockState);
                    if (vItemStack1.getItem() == Items.WATER_BUCKET) {
                        vItemStack1 = Services.PLATFORM.getWaterCopperBucketItem().getDefaultInstance();
                    }
                    if (!vItemStack1.isEmpty()) {
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
                        vBucketPickup.getPickupSound().ifPresent($$1x -> pPlayer.playSound($$1x, 1.0f, 1.0f));
                        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.FLUID_PICKUP, vBlockPos);
                        ItemStack vItemStack2 = ItemUtils.createFilledResult((ItemStack)vItemStack, (Player)pPlayer, (ItemStack)vItemStack1);
                        if (!pLevel.isClientSide) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)pPlayer, vItemStack1);
                        }
                        return InteractionResultHolder.sidedSuccess((Object)vItemStack2, (boolean)pLevel.isClientSide());
                    }
                }
                return InteractionResultHolder.fail((Object)vItemStack);
            }
            BlockState vBlockState = pLevel.getBlockState(vBlockPos);
            BlockPos blockPos = vBlockPos2 = vBlockState.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? vBlockPos : vBlockPos1;
            if (this.emptyContents(pPlayer, pLevel, vBlockPos2, vBlockHitResult)) {
                this.checkExtraContent(pPlayer, pLevel, vItemStack, vBlockPos2);
                if (pPlayer instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)pPlayer, vBlockPos2, vItemStack);
                }
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)CopperBucketItem.getEmptySuccessItem(vItemStack, pPlayer), (boolean)pLevel.isClientSide());
            }
            return InteractionResultHolder.fail((Object)vItemStack);
        }
        return InteractionResultHolder.fail((Object)vItemStack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        return !player.getAbilities().instabuild ? Services.PLATFORM.getEmptyCopperBucketItem().getDefaultInstance() : stack;
    }

    public void checkExtraContent(@Nullable Player $$0, Level $$1, ItemStack $$2, BlockPos $$3) {
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        boolean $$7;
        if (!(this.content instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        boolean $$6 = state.canBeReplaced(this.content);
        boolean bl = $$7 = state.isAir() || $$6 || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, state, this.content);
        if (!$$7) {
            return result != null && this.emptyContents(player, level, result.getBlockPos().relative(result.getDirection()), null);
        }
        if (level.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int $$8 = pos.getX();
            int $$9 = pos.getY();
            int $$10 = pos.getZ();
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int $$11 = 0; $$11 < 8; ++$$11) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)$$8 + Math.random(), (double)$$9 + Math.random(), (double)$$10 + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && this.content == Fluids.WATER) {
            ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)level, pos, state, ((FlowingFluid)this.content).getSource(false));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.isClientSide && $$6 && !state.liquid()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, this.content.defaultFluidState().createLegacyBlock(), 11) && !state.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable Player $$0, LevelAccessor $$1, BlockPos $$2) {
        SoundEvent $$3 = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        $$1.playSound($$0, $$2, $$3, SoundSource.BLOCKS, 1.0f, 1.0f);
        $$1.gameEvent((Entity)$$0, (Holder)GameEvent.FLUID_PLACE, $$2);
    }
}

