/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_useful_copper.core.registry;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import neoforge.com.cursee.more_useful_copper.core.registry.ModArmorMaterialsNeoForge;
import neoforge.com.cursee.more_useful_copper.core.registry.ModBlocksNeoForge;
import neoforge.com.cursee.more_useful_copper.core.registry.ModEntityTypesNeoForge;
import neoforge.com.cursee.more_useful_copper.core.registry.ModItemsNeoForge;
import neoforge.com.cursee.more_useful_copper.core.registry.ModLootTableModifiers;
import neoforge.com.cursee.more_useful_copper.core.registry.ModTabsNeoForge;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class RegistryNeoForge {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"more_useful_copper");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"more_useful_copper");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"more_useful_copper");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"more_useful_copper");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"more_useful_copper");
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"more_useful_copper");

    public static void register(IEventBus modEventBus) {
        ModArmorMaterialsNeoForge.register();
        ModBlocksNeoForge.register();
        ModEntityTypesNeoForge.register();
        ModItemsNeoForge.register();
        ModTabsNeoForge.register();
        ModLootTableModifiers.register();
        ARMOR_MATERIALS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
        LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
    }

    protected static <T extends Block> DeferredHolder<Block, T> registerBlock(String blockID, Supplier<T> blockSupplier) {
        return BLOCKS.register(blockID, blockSupplier);
    }

    protected static <T extends Block> DeferredHolder<Block, T> registerBlockWithItem(String blockID, Supplier<T> blockSupplier) {
        DeferredHolder toReturn = RegistryNeoForge.registerBlock(blockID, blockSupplier);
        RegistryNeoForge.registerItem(blockID, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    protected static <T extends EntityType<?>> DeferredHolder<EntityType<?>, T> registerEntityType(String entityTypeID, Supplier<T> entityTypeSupplier) {
        return ENTITY_TYPES.register(entityTypeID, entityTypeSupplier);
    }

    protected static <T extends Item> DeferredHolder<Item, T> registerItem(String itemID, Supplier<T> itemSupplier) {
        return ITEMS.register(itemID, itemSupplier);
    }

    protected static <T extends CreativeModeTab> DeferredHolder<CreativeModeTab, T> registerTab(String tabID, Supplier<T> tabSupplier) {
        return TABS.register(tabID, tabSupplier);
    }

    protected static <T extends MapCodec<? extends IGlobalLootModifier>> DeferredHolder<MapCodec<? extends IGlobalLootModifier>, T> registerLootModifierSerializer(String serializerID, Supplier<T> serializerSupplier) {
        return LOOT_MODIFIER_SERIALIZERS.register(serializerID, serializerSupplier);
    }
}

