/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ContainerInput;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardCombiningRecipe;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardBlockEntity
extends BasicLootBlockEntity {
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends SingleItemRecipe> slicingRecipeCache;
    private final RecipeManager.CachedCheck<ContainerInput, CuttingBoardCombiningRecipe> combiningRecipeCache;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends SingleItemRecipe> outputCache;
    protected final int useableContainerSize;
    protected boolean sync;
    protected boolean canExtract;
    protected boolean placedByPlayer;

    public CuttingBoardBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CUTTING_BOARD.get(), pos, state, 5, (RecipeType<? extends SingleItemRecipe>)((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get()), (RecipeType<CuttingBoardCombiningRecipe>)((RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get()));
    }

    public CuttingBoardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends SingleItemRecipe> slicingRecipeType, RecipeType<CuttingBoardCombiningRecipe> combiningRecipeType) {
        super(type, pos, state, containerSize + 1);
        this.useableContainerSize = containerSize;
        this.slicingRecipeCache = RecipeManager.createCheck(slicingRecipeType);
        this.combiningRecipeCache = RecipeManager.createCheck(combiningRecipeType);
        this.outputCache = RecipeManager.createCheck(slicingRecipeType);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "cutting_board", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return null;
    }

    public boolean placeItem(ItemStack heldItem) {
        int placeIndex = this.getPlaceIndex();
        if (this.canPlaceItem(placeIndex, heldItem)) {
            ItemStack copy = heldItem.copy();
            copy.setCount(1);
            heldItem.shrink(1);
            if (!this.level.isClientSide()) {
                this.placedByPlayer = true;
                this.canExtract = false;
                this.playPlaceIngredientSound(1.0f);
            }
            this.setItem(placeIndex, copy);
            return true;
        }
        return false;
    }

    public void removeItem() {
        int removeIndex = this.getHeadIndex();
        if (removeIndex >= 0 && !this.getItem(removeIndex).isEmpty()) {
            ItemStack stack = this.getItem(removeIndex);
            this.spawnItemIntoLevel(this.level, stack);
            this.setItem(removeIndex, ItemStack.EMPTY);
            this.canExtract = false;
        }
    }

    public boolean sliceItem(Level level, boolean spawnIntoLevel) {
        int sliceIndex = this.getHeadIndex();
        if (sliceIndex != 0) {
            return false;
        }
        ItemStack input = this.getItem(sliceIndex);
        Optional<? extends SingleItemRecipe> recipe = this.getSlicingRecipe(input);
        if (recipe.isPresent()) {
            if (!this.level.isClientSide()) {
                level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.ITEM_KNIFE_CHOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnSliceParticles(input);
                this.spawnSliceResultFromRecipe(sliceIndex, recipe.get(), spawnIntoLevel);
            }
            return true;
        }
        return false;
    }

    private void spawnSliceParticles(ItemStack stack) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.worldPosition;
            RandomSource rand = serverLevel.getRandom();
            for (int i = 0; i < 8; ++i) {
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, 1, rand.nextGaussian() * 0.15, rand.nextDouble() * 0.2, rand.nextGaussian() * 0.15, 0.0);
            }
        }
    }

    private void spawnMagicParticles() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.worldPosition;
            RandomSource rand = serverLevel.getRandom();
            for (int i = 0; i < 8; ++i) {
                double x = (double)pos.getX() + 0.5 + 0.3 * rand.nextGaussian();
                double y = (double)pos.getY() + 0.1;
                double z = (double)pos.getZ() + 0.5 + 0.3 * rand.nextGaussian();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.COMPOSTER, x, y, z, 1, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, 0.0);
            }
        }
    }

    private void spawnSliceResultFromRecipe(int sliceIndex, SingleItemRecipe recipe, boolean spawnIntoLevel) {
        Preconditions.checkNotNull((Object)this.level);
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (spawnIntoLevel) {
            this.spawnItemIntoLevel(this.level, result);
            this.setItem(sliceIndex, ItemStack.EMPTY);
            return;
        }
        this.setItem(sliceIndex, result.copy());
        this.canExtract = true;
    }

    private void spawnItemIntoLevel(Level level, ItemStack stack) {
        BlockPos pos = this.worldPosition;
        ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.0625, (double)pos.getZ() + 0.5, stack.copy());
        entity.setDefaultPickUpDelay();
        entity.setDeltaMovement(new Vec3(0.0, 0.15, 0.0));
        level.addFreshEntity((Entity)entity);
    }

    private void playPlaceIngredientSound(float pitch) {
        Level level = Objects.requireNonNull(this.level);
        Vec3 vec = Vec3.atBottomCenterOf((Vec3i)this.worldPosition);
        level.playSound(null, vec.x, vec.y, vec.z, (SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_PLACED_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch + 0.05f * (float)level.random.nextGaussian());
    }

    public int getPlaceIndex() {
        return this.getHeadIndex() + 1;
    }

    public int getHeadIndex() {
        for (int i = this.useableContainerSize - 1; i >= 0; --i) {
            if (this.getItem(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return slotIndex >= 0 && slotIndex < this.useableContainerSize && slotIndex == this.getPlaceIndex() && this.isSlotInsertable(slotIndex) && this.canPlaceOnTop(stack);
    }

    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        if (slotIndex >= 0 && slotIndex < this.useableContainerSize && slotIndex == this.getHeadIndex() && this.canExtract) {
            return this.outputCache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), Objects.requireNonNull(this.level)).isEmpty();
        }
        return false;
    }

    public void setItem(int slotIndex, ItemStack stack) {
        super.setItem(slotIndex, stack);
        if (!stack.isEmpty() && this.getHeadIndex() >= 0 && !Objects.requireNonNull(this.level).isClientSide()) {
            this.craftCombiningRecipe(this.placedByPlayer);
        }
    }

    public ItemStack removeItem(int slotIndex, int count) {
        ItemStack stack = super.removeItem(slotIndex, count);
        if (this.isEmpty()) {
            this.canExtract = false;
        }
        return stack;
    }

    @Override
    protected boolean isSlotInsertable(int slotIndex) {
        ItemStack target = this.getItem(slotIndex);
        return target.isEmpty() || target.getCount() < target.getMaxStackSize() && target.getCount() < 1;
    }

    public boolean canPlaceOnTop(ItemStack stack) {
        return this.getNextCombiningRecipe(stack).isPresent() || this.getHeadIndex() == -1 && this.getSlicingRecipe(stack).isPresent();
    }

    private Optional<? extends SingleItemRecipe> getSlicingRecipe(ItemStack stack) {
        return this.slicingRecipeCache.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), Objects.requireNonNull(this.level)).map(RecipeHolder::value);
    }

    private Optional<CuttingBoardCombiningRecipe> getCombiningRecipe() {
        return this.combiningRecipeCache.getRecipeFor((RecipeInput)new ContainerInput((Container)this), Objects.requireNonNull(this.level)).map(RecipeHolder::value);
    }

    private Optional<CuttingBoardCombiningRecipe> getNextCombiningRecipe(ItemStack stack) {
        int placeIndex = this.getPlaceIndex();
        if (placeIndex >= this.useableContainerSize) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(placeIndex + 1);
        IntStream.range(0, placeIndex + 1).forEach(arg_0 -> this.lambda$getNextCombiningRecipe$0((Container)container, arg_0));
        container.setItem(container.getContainerSize() - 1, stack);
        return this.combiningRecipeCache.getRecipeFor((RecipeInput)new ContainerInput((Container)container), Objects.requireNonNull(this.level)).map(RecipeHolder::value);
    }

    private void craftCombiningRecipe(boolean spawnIntoLevel) {
        this.placedByPlayer = false;
        Optional<CuttingBoardCombiningRecipe> optional = this.getCombiningRecipe();
        if (optional.isEmpty()) {
            return;
        }
        CuttingBoardCombiningRecipe recipe = optional.get();
        if (!recipe.completelyMatches((Container)this)) {
            return;
        }
        Level level = Objects.requireNonNull(this.level);
        ItemStack stack = recipe.assemble(new ContainerInput((Container)this), (HolderLookup.Provider)level.registryAccess());
        List<ItemStack> remainingItems = this.getCraftingRemainingItems();
        this.clearContent();
        this.setChanged();
        this.spawnSliceParticles(stack);
        this.spawnMagicParticles();
        Vec3 center = Vec3.atBottomCenterOf((Vec3i)this.worldPosition);
        level.playSound(null, center.x, center.y, center.z, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (spawnIntoLevel) {
            this.spawnItemIntoLevel(level, stack);
            remainingItems.forEach(item -> this.spawnItemIntoLevel(this.level, (ItemStack)item));
            return;
        }
        this.setItem(0, stack);
        for (int i = 0; i < remainingItems.size() && i < this.useableContainerSize; ++i) {
            this.setItem(i + 1, remainingItems.get(i));
        }
        this.canExtract = true;
    }

    private List<ItemStack> getCraftingRemainingItems() {
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.useableContainerSize; ++i) {
            Item item;
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty() || !stack.getItem().hasCraftingRemainingItem() || (item = stack.getItem().getCraftingRemainingItem()) == null) continue;
            remainingItems.add(new ItemStack((ItemLike)item));
        }
        return remainingItems;
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    protected void sync() {
        this.sync = true;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CuttingBoardBlockEntity entity) {
        if (entity.sync) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)entity, BlockEntity::getUpdateTag);
            entity.sync = false;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("CanExtract", this.canExtract);
        tag.putBoolean("PlacedByPlayer", this.placedByPlayer);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("CanExtract", 1)) {
            this.canExtract = compound.getBoolean("CanExtract");
        }
        if (compound.contains("PlacedByPlayer", 1)) {
            this.placedByPlayer = compound.getBoolean("PlacedByPlayer");
        }
    }

    private /* synthetic */ void lambda$getNextCombiningRecipe$0(Container container, int index) {
        container.setItem(index, this.getItem(index));
    }
}

