/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.ender_pack.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.atomic.AtomicBoolean;
import neoforge.com.cursee.ender_pack.EnderPackClient;
import neoforge.com.cursee.ender_pack.client.ClientConfiguredValues;
import neoforge.com.cursee.ender_pack.client.model.EnderPackModel;
import neoforge.com.cursee.ender_pack.core.registry.ModItems;
import neoforge.com.cursee.ender_pack.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EnderPackLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final EnderPackModel model = new EnderPackModel(Minecraft.getInstance().getEntityModels().bakeLayer(EnderPackClient.ENDER_PACK_PLAYER_MODEL_LAYER_LOCATION));

    public EnderPackLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i, @NotNull Player entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AtomicBoolean SHOULD_RENDER_BAG = new AtomicBoolean(false);
        entity.getInventory().armor.forEach(stack -> {
            if (stack.is(ModItems.ENDER_PACK)) {
                SHOULD_RENDER_BAG.set(ClientConfiguredValues.RENDERS_IN_ARMOR_SLOT);
            }
        });
        if ((Services.PLATFORM.isModLoaded("curios") || Services.PLATFORM.isModLoaded("trinkets")) && Services.PLATFORM.checkCompatibleSlots(entity)) {
            SHOULD_RENDER_BAG.set(ClientConfiguredValues.RENDERS_IN_EXTRA_SLOT);
        }
        if (!SHOULD_RENDER_BAG.get()) {
            return;
        }
        poseStack.pushPose();
        boolean crouching = entity.isCrouching();
        if (crouching) {
            poseStack.mulPose(new Matrix4f().setRotationXYZ(0.5235988f, 0.0f, 0.0f));
        } else {
            poseStack.mulPose(new Matrix4f().setRotationXYZ(0.0f, 0.0f, 0.0f));
        }
        float xOffset = -0.0625f;
        float yOffset = crouching ? 0.25f : 0.0625f;
        float zOffset = crouching ? 0.83f : 0.9375f;
        poseStack.translate(-0.0625f, yOffset, zOffset);
        RenderLayer.renderColoredCutoutModel((EntityModel)this.model, (ResourceLocation)EnderPackClient.ENDER_PACK_TEXTURE_LOCATION, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)entity, (int)-1);
        poseStack.popPose();
    }
}

