/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.exclusive_weapons.item;

import com.cerbon.exclusive_weapons.item.EWItems;
import com.cerbon.exclusive_weapons.registry.RegistryEntry;
import com.cerbon.exclusive_weapons.registry.ResourcefulRegistries;
import com.cerbon.exclusive_weapons.registry.ResourcefulRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EWArmorMaterials {
    public static final ResourcefulRegistry<ArmorMaterial> ARMOR_MATERIALS = ResourcefulRegistries.create(BuiltInRegistries.ARMOR_MATERIAL, "exclusive_weapons");
    public static final RegistryEntry<ArmorMaterial> SUPER_IRON = EWArmorMaterials.register("super_iron", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, (int)EWItems.addBoost(2));
        enumMap.put(ArmorItem.Type.LEGGINGS, (int)EWItems.addBoost(5));
        enumMap.put(ArmorItem.Type.CHESTPLATE, (int)EWItems.addBoost(6));
        enumMap.put(ArmorItem.Type.HELMET, (int)EWItems.addBoost(2));
        enumMap.put(ArmorItem.Type.BODY, (int)EWItems.addBoost(5));
    }), (int)EWItems.addBoost(9), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 0.0f, 0.0f, () -> Items.IRON_INGOT);
    public static final RegistryEntry<ArmorMaterial> SUPER_GOLD = EWArmorMaterials.register("super_gold", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, (int)EWItems.addBoost(1));
        enumMap.put(ArmorItem.Type.LEGGINGS, (int)EWItems.addBoost(3));
        enumMap.put(ArmorItem.Type.CHESTPLATE, (int)EWItems.addBoost(5));
        enumMap.put(ArmorItem.Type.HELMET, (int)EWItems.addBoost(2));
        enumMap.put(ArmorItem.Type.BODY, (int)EWItems.addBoost(7));
    }), (int)EWItems.addBoost(25), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, 0.0f, 0.0f, () -> Items.GOLD_INGOT);
    public static final RegistryEntry<ArmorMaterial> SUPER_DIAMOND = EWArmorMaterials.register("super_diamond", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, (int)EWItems.addBoost(3));
        enumMap.put(ArmorItem.Type.LEGGINGS, (int)EWItems.addBoost(6));
        enumMap.put(ArmorItem.Type.CHESTPLATE, (int)EWItems.addBoost(8));
        enumMap.put(ArmorItem.Type.HELMET, (int)EWItems.addBoost(3));
        enumMap.put(ArmorItem.Type.BODY, (int)EWItems.addBoost(11));
    }), (int)EWItems.addBoost(10), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, EWItems.addBoost(Float.valueOf(2.0f)), 0.0f, () -> Items.DIAMOND);
    public static final RegistryEntry<ArmorMaterial> SUPER_NETHERITE = EWArmorMaterials.register("super_netherite", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), enumMap -> {
        enumMap.put(ArmorItem.Type.BOOTS, (int)EWItems.addBoost(3));
        enumMap.put(ArmorItem.Type.LEGGINGS, (int)EWItems.addBoost(6));
        enumMap.put(ArmorItem.Type.CHESTPLATE, (int)EWItems.addBoost(8));
        enumMap.put(ArmorItem.Type.HELMET, (int)EWItems.addBoost(3));
        enumMap.put(ArmorItem.Type.BODY, (int)EWItems.addBoost(11));
    }), (int)EWItems.addBoost(15), (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, EWItems.addBoost(Float.valueOf(3.0f)), EWItems.addBoost(Float.valueOf(0.1f)), () -> Items.NETHERITE_INGOT);

    private static RegistryEntry<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtection, int enchantability, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Item> ingredientItem) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"exclusive_weapons", (String)name);
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingredientItem.get()});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(location));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtection.get(type));
        }
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)typeProtection, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }

    public static void register() {
        ARMOR_MATERIALS.register();
    }
}

