/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.systems.wanderer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.json.OptionalStackCodec;
import dev.shadowsoffire.placebo.systems.wanderer.WandererTrade;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.BasicItemListing;

public class BasicWandererTrade
extends BasicItemListing
implements WandererTrade {
    public static Codec<BasicWandererTrade> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)OptionalStackCodec.INSTANCE.fieldOf("input_1").forGetter(trade -> trade.price), (App)OptionalStackCodec.INSTANCE.optionalFieldOf("input_2", (Object)ItemStack.EMPTY).forGetter(trade -> trade.price2), (App)OptionalStackCodec.INSTANCE.fieldOf("output").forGetter(trade -> trade.forSale), (App)Codec.INT.optionalFieldOf("max_trades", (Object)1).forGetter(trade -> trade.maxTrades), (App)Codec.INT.optionalFieldOf("xp", (Object)0).forGetter(trade -> trade.xp), (App)Codec.FLOAT.optionalFieldOf("price_mult", (Object)Float.valueOf(1.0f)).forGetter(trade -> Float.valueOf(trade.priceMult)), (App)Codec.BOOL.optionalFieldOf("rare", (Object)false).forGetter(trade -> trade.rare)).apply((Applicative)inst, BasicWandererTrade::new));
    protected final boolean rare;

    public BasicWandererTrade(ItemStack price, ItemStack price2, ItemStack forSale, int maxTrades, int xp, float priceMult, boolean rare) {
        super(price, price2, forSale, maxTrades, xp, priceMult);
        this.rare = rare;
    }

    @Override
    public boolean isRare() {
        return this.rare;
    }

    @Override
    public Codec<? extends WandererTrade> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ItemStack price = ItemStack.EMPTY;
        private ItemStack price2 = ItemStack.EMPTY;
        private ItemStack forSale = ItemStack.EMPTY;
        private int maxTrades = 1;
        private int xp = 0;
        private float priceMult = 1.0f;
        private boolean rare = false;

        public Builder price(ItemStack price) {
            this.price = price;
            return this;
        }

        public Builder price(Item price, int count) {
            return this.price(new ItemStack((ItemLike)price, count));
        }

        public Builder price2(ItemStack price2) {
            this.price2 = price2;
            return this;
        }

        public Builder price2(Item price, int count) {
            return this.price2(new ItemStack((ItemLike)price, count));
        }

        public Builder forSale(ItemStack forSale) {
            this.forSale = forSale;
            return this;
        }

        public Builder forSale(Item output, int count) {
            return this.forSale(new ItemStack((ItemLike)output, count));
        }

        public Builder maxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        public Builder xp(int xp) {
            this.xp = xp;
            return this;
        }

        public Builder priceMult(float priceMult) {
            this.priceMult = priceMult;
            return this;
        }

        public Builder rare() {
            this.rare = true;
            return this;
        }

        public BasicWandererTrade build() {
            return new BasicWandererTrade(this.price, this.price2, this.forSale, this.maxTrades, this.xp, this.priceMult, this.rare);
        }
    }
}

