/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates.properties;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.teamresourceful.resourcefullib.common.codecs.predicates.properties.ExactPropertyMatcher;
import com.teamresourceful.resourcefullib.common.codecs.predicates.properties.RangePropertyMatcher;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public interface PropertyMatcher {
    public static final Codec<PropertyMatcher> CODEC = Codec.either(ExactPropertyMatcher.CODEC, RangePropertyMatcher.CODEC).flatXmap(either -> DataResult.success((Object)((Record)either.map(p -> p, p -> p))), matcher -> {
        if (matcher instanceof ExactPropertyMatcher) {
            ExactPropertyMatcher exactMatcher = (ExactPropertyMatcher)matcher;
            return DataResult.success((Object)Either.left((Object)exactMatcher));
        }
        if (matcher instanceof RangePropertyMatcher) {
            RangePropertyMatcher rangeMatcher = (RangePropertyMatcher)matcher;
            return DataResult.success((Object)Either.right((Object)rangeMatcher));
        }
        return DataResult.error(() -> "Unknown PropertyMatcher type");
    });

    default public <S extends StateHolder<?, S>> boolean match(String name, StateDefinition<?, S> definition, S holder) {
        Property property = definition.getProperty(name);
        return property != null && this.match(holder, property);
    }

    public <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);

    public Codec<? extends PropertyMatcher> codec();

    public Optional<String> value(RandomSource var1);
}

