/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.client.model;

import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PenguinModel<T extends AdeliePenguinEntity>
extends AgeableListModel<T> {
    private ModelPart head;
    private ModelPart beak;
    private ModelPart body;
    private ModelPart flipperLeft;
    private ModelPart flipperRight;
    private ModelPart feetLeft;
    private ModelPart feetRight;
    private ModelPart tail;

    public PenguinModel(ModelPart part) {
        super(false, 6.0f, 0.0f);
        this.head = part.getChild("head");
        this.beak = part.getChild("beak");
        this.body = part.getChild("body");
        this.flipperLeft = part.getChild("flipper_left");
        this.flipperRight = part.getChild("flipper_right");
        this.feetLeft = part.getChild("feet_left");
        this.feetRight = part.getChild("feet_right");
        this.tail = part.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelDefinition = new MeshDefinition();
        PartDefinition def = modelDefinition.getRoot();
        def.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        def.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, -3.0f, -4.0f, 1.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        def.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-2.5f, 0.0f, -2.0f, 5.0f, 11.0f, 5.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)1.0f));
        def.addOrReplaceChild("flipper_left", CubeListBuilder.create().texOffs(20, 10).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)2.5f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.08726646f));
        def.addOrReplaceChild("flipper_right", CubeListBuilder.create().texOffs(20, 10).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)-2.5f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.08726646f));
        def.addOrReplaceChild("feet_left", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(0.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)1.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f));
        def.addOrReplaceChild("feet_right", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, 0.0f, -3.0f, 2.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)-1.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        def.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(20, 20).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)23.0f, (float)3.0f, (float)1.2566371f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelDefinition, (int)32, (int)32);
    }

    @Nonnull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.beak);
    }

    @Nonnull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.flipperLeft, (Object)this.flipperRight, (Object)this.feetLeft, (Object)this.feetRight, (Object)this.tail);
    }

    public void setupAnim(@Nonnull AdeliePenguinEntity penguin, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.zRot = Mth.cos((float)(limbSwing * 1.3324f)) * 1.4f * limbSwingAmount / 6.0f;
        this.beak.xRot = this.head.xRot;
        this.beak.yRot = this.head.yRot;
        this.body.zRot = Mth.cos((float)(limbSwing * 1.3324f)) * 1.4f * limbSwingAmount / 6.0f;
        this.feetRight.xRot = Mth.cos((float)(limbSwing * 1.3324f)) * 1.2f * limbSwingAmount;
        this.feetLeft.xRot = Mth.cos((float)(limbSwing * 1.3324f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.flipperRight.zRot = 0.08726646f + Mth.cos((float)penguin.rotationFlipper) * limbSwingAmount;
        this.flipperLeft.zRot = -0.08726646f + Mth.cos((float)((float)penguin.rotationFlipper + (float)Math.PI)) * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * 1.4f * limbSwingAmount;
    }
}

