/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.entity;

import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.init.WaddlesSounds;
import com.girafi.waddles.utils.ConfigurationHandler;
import com.girafi.waddles.utils.WaddlesTags;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class AdeliePenguinEntity
extends Animal {
    private static final EntityDimensions BABY_DIMENSIONS = PenguinRegistry.ADELIE_PENGUIN.get().getDimensions().scale(0.5f).withEyeHeight(0.5f);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.COD, Items.SALMON});
    public short rotationFlipper;
    private boolean moveFlipper = false;

    public AdeliePenguinEntity(EntityType<? extends Animal> adelie, Level level) {
        super(adelie, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EntityAIExtinguishFire());
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)TEMPTATION_ITEMS, false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nonnull
    public EntityDimensions getDefaultDimensions(@Nonnull Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.16);
    }

    public float getWalkTargetValue(@Nonnull BlockPos pos, @Nonnull LevelReader levelReader) {
        BlockState stateDown = levelReader.getBlockState(pos.below());
        if (stateDown.is(WaddlesTags.PENGUIN_SPAWNABLE_BLOCKS)) {
            return 10.0f;
        }
        return super.getWalkTargetValue(pos, levelReader);
    }

    protected SoundEvent getAmbientSound() {
        return this.isBaby() ? WaddlesSounds.ADELIE_BABY_AMBIENT.get() : WaddlesSounds.ADELIE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@Nonnull DamageSource source) {
        return WaddlesSounds.ADELIE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return WaddlesSounds.ADELIE_DEATH.get();
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide && this.getX() != this.zo && this.moveFlipper) {
            this.rotationFlipper = (short)(this.rotationFlipper + 1);
        }
    }

    public int getBaseExperienceReward() {
        if (((Boolean)ConfigurationHandler.GENERAL.dropExp.get()).booleanValue()) {
            return super.getBaseExperienceReward();
        }
        return 0;
    }

    public boolean isFood(@Nonnull ItemStack stack) {
        return !stack.isEmpty() && TEMPTATION_ITEMS.test(stack);
    }

    @Nonnull
    public ResourceKey<LootTable> getDefaultLootTable() {
        return (Boolean)ConfigurationHandler.GENERAL.dropFish.get() != false ? super.getDefaultLootTable() : BuiltInLootTables.EMPTY;
    }

    public AgeableMob getBreedOffspring(@Nonnull ServerLevel serverLevel, @Nonnull AgeableMob ageableMob) {
        return (AgeableMob)PenguinRegistry.ADELIE_PENGUIN.get().create(this.level());
    }

    public static boolean canPenguinSpawn(EntityType<? extends Animal> animal, ServerLevelAccessor serverLevelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return serverLevelAccessor.getBlockState(pos.below()).is(WaddlesTags.PENGUIN_SPAWNABLE_BLOCKS) && AdeliePenguinEntity.isBrightEnoughToSpawn((BlockAndTintGetter)serverLevelAccessor, (BlockPos)pos);
    }

    private class EntityAIExtinguishFire
    extends PanicGoal {
        EntityAIExtinguishFire() {
            super((PathfinderMob)AdeliePenguinEntity.this, 2.0);
        }

        public boolean canUse() {
            return (AdeliePenguinEntity.this.isBaby() || AdeliePenguinEntity.this.isOnFire()) && super.canUse();
        }
    }
}

