/*
 * Decompiled with CFR 0.152.
 */
package com.zv;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ServerState
extends SavedData {
    public static final String ID = "zombie_variants_server_state";
    public ConcurrentHashMap<BlockPos, Boolean> pyramidLocations = new ConcurrentHashMap();
    private static final SavedData.Factory<ServerState> FACTORY = new SavedData.Factory(ServerState::new, ServerState::new, null);

    public static ServerState get(Entity entity) {
        return ServerState.get(entity.getServer());
    }

    public static ServerState get(LevelAccessor world) {
        return ServerState.get(world.getServer());
    }

    public static ServerState get(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.getLevel(Level.OVERWORLD).getDataStorage();
        ServerState serverState = (ServerState)persistentStateManager.computeIfAbsent(FACTORY, ID);
        serverState.setDirty();
        return serverState;
    }

    private ServerState() {
    }

    private ServerState(CompoundTag tag, HolderLookup.Provider registryLookup) {
        if (tag.contains("pyramidLocations")) {
            ListTag list = tag.getList("pyramidLocations", 10);
            for (Tag element : list) {
                CompoundTag compound = (CompoundTag)element;
                BlockPos pos = BlockPos.of((long)compound.getLong("pos"));
                boolean hasPyramid = compound.getBoolean("hasPyramid");
                this.pyramidLocations.put(pos, hasPyramid);
            }
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.pyramidLocations.keySet()) {
            CompoundTag compound = new CompoundTag();
            compound.putLong("pos", pos.asLong());
            compound.putBoolean("hasPyramid", this.pyramidLocations.get(pos).booleanValue());
            list.add((Object)compound);
        }
        nbt.put("pyramidLocations", (Tag)list);
        return nbt;
    }
}

