/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class ChunkLoaderBlockEntityRenderer
implements CustomBlockEntityRenderer<ChunkLoaderBlockEntity> {
    private final Block block;
    private final boolean fullRotation;

    public ChunkLoaderBlockEntityRenderer(Block block, boolean fullRotation) {
        this.block = block;
        this.fullRotation = fullRotation;
    }

    public void render(ChunkLoaderBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.pushPose();
        double offset = Math.sin((double)((float)((System.currentTimeMillis() + (long)entity.animationOffset) % 5000L) / 5000.0f * 2.0f) * Math.PI) * 0.1;
        poseStack.translate(0.0, offset, 0.0);
        poseStack.translate(0.5, 0.5, 0.5);
        if (this.fullRotation) {
            float angleX = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 13000L) / 13000.0f * 2.0f * (float)Math.PI;
            float angleY = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 15000L) / 15000.0f * 2.0f * (float)Math.PI;
            float angleZ = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 16000L) / 16000.0f * 2.0f * (float)Math.PI;
            poseStack.mulPose(new Quaternionf().setAngleAxis(angleX, 1.0f, 0.0f, 0.0f));
            poseStack.mulPose(new Quaternionf().setAngleAxis(angleY, 0.0f, 1.0f, 0.0f));
            poseStack.mulPose(new Quaternionf().setAngleAxis(angleZ, 0.0f, 0.0f, 1.0f));
        } else {
            float angle = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 11000L) / 11000.0f * 2.0f * (float)Math.PI;
            poseStack.mulPose(new Quaternionf().setAngleAxis(angle, 0.0f, 1.0f, 0.0f));
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        BlockRenderDispatcher blockRenderer = ClientUtils.getBlockRenderer();
        BakedModel model = blockRenderer.getBlockModel(this.block.defaultBlockState());
        for (RenderType type : model.getRenderTypes(this.block.defaultBlockState(), RandomSource.create(), ModelData.EMPTY)) {
            blockRenderer.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(type), this.block.defaultBlockState(), model, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, ModelData.EMPTY, type);
        }
        poseStack.popPose();
    }
}

