/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public class PlayerActivityTracker {
    private static final Set<UUID> activePlayers = new LinkedHashSet<UUID>();
    private static final Set<UUID> onlinePlayers = new LinkedHashSet<UUID>();
    private static final Map<UUID, ActiveTime> lastActiveTimePerPlayer = new HashMap<UUID, ActiveTime>();
    private static final SortedSet<ActiveTime> sortedActiveTimes = new TreeSet<ActiveTime>();
    private static boolean dirty = false;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ActiveTime lastActiveTime;
        UUID playerId = e.getEntity().getUUID();
        onlinePlayers.add(playerId);
        if (!activePlayers.contains(playerId)) {
            activePlayers.add(playerId);
            if (PlayerActivityTracker.isInactivityTimeOutEnabled()) {
                e.getEntity().getServer().getAllLevels().forEach(level -> ChunkLoadingCapability.get((Level)level).castServer().togglePlayerActivity(playerId, true));
            }
        }
        if ((lastActiveTime = lastActiveTimePerPlayer.remove(playerId)) != null) {
            sortedActiveTimes.remove(lastActiveTime);
        }
        dirty = true;
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent e) {
        UUID playerId = e.getEntity().getUUID();
        onlinePlayers.remove(playerId);
        ActiveTime lastActiveTime = new ActiveTime(playerId, System.currentTimeMillis());
        lastActiveTimePerPlayer.put(playerId, lastActiveTime);
        sortedActiveTimes.add(lastActiveTime);
        dirty = true;
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post e) {
        long timeoutTime = System.currentTimeMillis() - PlayerActivityTracker.getInactivityTimeout();
        while (!sortedActiveTimes.isEmpty()) {
            ActiveTime earliestExpiringTime = sortedActiveTimes.first();
            if (earliestExpiringTime.lastActiveTime >= timeoutTime) break;
            sortedActiveTimes.remove(earliestExpiringTime);
            lastActiveTimePerPlayer.remove(earliestExpiringTime.player);
            activePlayers.remove(earliestExpiringTime.player);
            dirty = true;
            ActiveTime finalEarliestExpiringTime = earliestExpiringTime;
            if (!PlayerActivityTracker.isInactivityTimeOutEnabled()) continue;
            ServerLifecycleHooks.getCurrentServer().getAllLevels().forEach(level -> ChunkLoadingCapability.get((Level)level).castServer().togglePlayerActivity(finalEarliestExpiringTime.player, false));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerAboutToStartEvent e) {
        activePlayers.clear();
        onlinePlayers.clear();
        lastActiveTimePerPlayer.clear();
        sortedActiveTimes.clear();
        dirty = false;
        Path path = e.getServer().getWorldPath(LevelResource.ROOT).resolve("chunkloaders/active_players.nbt");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            CompoundTag data = NbtIo.read((Path)path);
            if (data != null) {
                PlayerActivityTracker.read(data);
            }
        }
        catch (IOException exception) {
            ChunkLoaders.LOGGER.error("Failed to load player activity data!", (Throwable)exception);
        }
    }

    @SubscribeEvent
    public static void onWorldSave(LevelEvent.Save e) {
        if (!(e.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (dirty) {
            CompoundTag data = PlayerActivityTracker.write();
            Path path = e.getLevel().getServer().getWorldPath(LevelResource.ROOT).resolve("chunkloaders/active_players.nbt");
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                NbtIo.write((CompoundTag)data, (Path)path);
            }
            catch (IOException exception) {
                ChunkLoaders.LOGGER.error("Failed to write active player data!", (Throwable)exception);
                return;
            }
            dirty = false;
        }
    }

    public static boolean isPlayerActive(UUID player) {
        return !PlayerActivityTracker.isInactivityTimeOutEnabled() || activePlayers.contains(player);
    }

    private static boolean isInactivityTimeOutEnabled() {
        return ChunkLoadersConfig.inactivityTimeout.get() > 0L;
    }

    private static long getInactivityTimeout() {
        return ChunkLoadersConfig.inactivityTimeout.get() * 60L * 1000L;
    }

    private static CompoundTag write() {
        CompoundTag tag;
        ListTag activeTimes = new ListTag();
        for (UUID player : onlinePlayers) {
            tag = new CompoundTag();
            tag.putUUID("player", player);
            tag.putLong("time", System.currentTimeMillis());
            activeTimes.add((Object)tag);
        }
        for (ActiveTime activeTime : lastActiveTimePerPlayer.values()) {
            tag = new CompoundTag();
            tag.putUUID("player", activeTime.player);
            tag.putLong("time", activeTime.lastActiveTime);
            activeTimes.add((Object)tag);
        }
        CompoundTag tag2 = new CompoundTag();
        tag2.put("times", (Tag)activeTimes);
        return tag2;
    }

    private static void read(CompoundTag tag) {
        ListTag activeTimes = tag.getList("times", 10);
        for (Tag nbt : activeTimes) {
            CompoundTag timeTag;
            if (!(nbt instanceof CompoundTag) || !(timeTag = (CompoundTag)nbt).contains("player", 11) || !timeTag.contains("time", 4)) continue;
            ActiveTime activeTime = new ActiveTime(timeTag.getUUID("player"), timeTag.getLong("time"));
            activePlayers.add(activeTime.player);
            sortedActiveTimes.add(activeTime);
        }
    }

    private static class ActiveTime
    implements Comparable<ActiveTime> {
        public final UUID player;
        public long lastActiveTime;

        public ActiveTime(UUID player, long lastActiveTime) {
            this.player = player;
            this.lastActiveTime = lastActiveTime;
        }

        @Override
        public int compareTo(ActiveTime other) {
            return Long.compare(this.lastActiveTime, other.lastActiveTime);
        }
    }
}

