/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.common.UsernameCache;

public class PlayerRenderer {
    private static final Map<UUID, GameProfile> PLAYER_PROFILE_MAP = new HashMap<UUID, GameProfile>();
    private static final HashSet<UUID> FETCH_QUEUE = new HashSet();

    public static void renderPlayerHead(UUID player, PoseStack poseStack, int x, int y, int width, int height) {
        ScreenUtils.bindTexture((ResourceLocation)PlayerRenderer.getPlayerSkin(player));
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)x, (float)y, (float)width, (float)height, (float)0.125f, (float)0.125f, (float)0.125f, (float)0.125f);
    }

    public static String getPlayerUsername(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        return profile == null ? UsernameCache.getLastKnownUsername((UUID)player) : profile.getName();
    }

    public static ResourceLocation getPlayerSkin(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        if (profile != null) {
            return ClientUtils.getMinecraft().getSkinManager().getInsecureSkin(profile).texture();
        }
        return DefaultPlayerSkin.get((UUID)player).texture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameProfile fetchPlayerProfile(UUID player) {
        Object object = PLAYER_PROFILE_MAP;
        synchronized (object) {
            GameProfile profile = PLAYER_PROFILE_MAP.get(player);
            if (profile != null) {
                return profile;
            }
        }
        object = FETCH_QUEUE;
        synchronized (object) {
            if (FETCH_QUEUE.add(player)) {
                new Thread(() -> {
                    GameProfile profile;
                    boolean success = false;
                    String name = PlayerRenderer.fetchPlayerName(player);
                    if (name != null && (profile = PlayerRenderer.updateGameProfile(new GameProfile(player, name))) != null) {
                        Map<UUID, GameProfile> map = PLAYER_PROFILE_MAP;
                        synchronized (map) {
                            PLAYER_PROFILE_MAP.put(player, profile);
                        }
                        success = true;
                    }
                    if (!success) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    HashSet<UUID> hashSet = FETCH_QUEUE;
                    synchronized (hashSet) {
                        FETCH_QUEUE.remove(player);
                    }
                }, "Chunk Loaders - Game profile fetching").start();
            }
        }
        return null;
    }

    @Nullable
    private static GameProfile updateGameProfile(@Nullable GameProfile input) {
        MinecraftSessionService sessionService;
        ProfileResult fetchResult;
        if (input != null && input.getId() != null && (fetchResult = (sessionService = PlayerRenderer.getSessionService()).fetchProfile(input.getId(), true)) != null) {
            return fetchResult.profile();
        }
        return null;
    }

    private static String fetchPlayerName(UUID player) {
        try {
            JsonObject json;
            String s;
            InputStream inputStream = new URL("https://api.mojang.com/user/profile/" + String.valueOf(player)).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                builder.append(s);
            }
            if (builder.length() > 0 && (json = GsonHelper.parse((String)builder.toString())).has("name")) {
                return json.get("name").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static MinecraftSessionService getSessionService() {
        return ClientUtils.getMinecraft().getMinecraftSessionService();
    }
}

