/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.danger_close;

import com.cursee.danger_close.core.CommonConfigValues;
import com.cursee.danger_close.core.optional.SoulFired;
import com.cursee.danger_close.platform.Services;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DangerClose {
    public static final TagKey<Block> TORCH_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DangerClose.identifier("torch_burn_danger"));
    public static final TagKey<Block> SOUL_TORCH_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DangerClose.identifier("soul_torch_burn_danger"));
    public static final TagKey<Block> CAMPFIRE_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DangerClose.identifier("campfire_burn_danger"));
    public static final TagKey<Block> SOUL_CAMPFIRE_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DangerClose.identifier("soul_campfire_burn_danger"));
    public static final TagKey<Block> MAGMA_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DangerClose.identifier("magma_burn_danger"));
    public static final TagKey<Block> STONECUTTER_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DangerClose.identifier("stonecutter_danger"));
    public static final Predicate<TagKey<Block>> TORCH_MATCH = tag -> tag == TORCH_BURN_DANGER;
    public static final Predicate<TagKey<Block>> SOUL_TORCH_MATCH = tag -> tag == SOUL_TORCH_BURN_DANGER;
    public static final Predicate<TagKey<Block>> CAMPFIRE_MATCH = tag -> tag == CAMPFIRE_BURN_DANGER;
    public static final Predicate<TagKey<Block>> SOUL_CAMPFIRE_MATCH = tag -> tag == SOUL_CAMPFIRE_BURN_DANGER;
    public static final Predicate<TagKey<Block>> MAGMA_MATCH = tag -> tag == MAGMA_BURN_DANGER;
    public static final Predicate<TagKey<Block>> STONECUTTER_MATCH = tag -> tag == STONECUTTER_DANGER;
    public static boolean isSoulFiredLoaded = false;

    public static void init() {
        isSoulFiredLoaded = Services.PLATFORM.isModLoaded("soul_fire_d");
    }

    public static ResourceLocation identifier(String value) {
        return ResourceLocation.fromNamespaceAndPath((String)"danger_close", (String)value);
    }

    public static void detect(LivingEntity entity) {
        if (!CommonConfigValues.shouldDetect) {
            return;
        }
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (entity.onGround()) {
            boolean hasFrostWalker;
            BlockPos pos = entity.blockPosition();
            BlockState stateInside = level.getBlockState(pos);
            BlockState stateBelow = level.getBlockState(pos.below());
            ItemStack feetItemStack = entity.getItemBySlot(EquipmentSlot.FEET);
            boolean hasEnchantedFeetSlotItem = feetItemStack != ItemStack.EMPTY && EnchantmentHelper.hasAnyEnchantments((ItemStack)feetItemStack);
            boolean bl = hasFrostWalker = hasEnchantedFeetSlotItem && feetItemStack.getEnchantments().keySet().stream().anyMatch(enchantmentHolder -> enchantmentHolder.is(Enchantments.FROST_WALKER));
            if (CommonConfigValues.shouldTorchImmolate && !hasFrostWalker) {
                if (stateInside.getTags().anyMatch(TORCH_MATCH)) {
                    DangerClose.immolate(entity);
                } else if (stateBelow.getTags().anyMatch(TORCH_MATCH)) {
                    DangerClose.immolate(entity);
                }
            }
            if (CommonConfigValues.shouldSoulTorchImmolate && !hasFrostWalker) {
                if (stateInside.getTags().anyMatch(SOUL_TORCH_MATCH)) {
                    DangerClose.immolateSoul(entity);
                } else if (stateBelow.getTags().anyMatch(SOUL_TORCH_MATCH)) {
                    DangerClose.immolateSoul(entity);
                }
            }
            if (CommonConfigValues.shouldCampfireImmolate && !hasFrostWalker) {
                if (stateInside.getTags().anyMatch(CAMPFIRE_MATCH) && ((Boolean)stateInside.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    DangerClose.immolate(entity);
                } else if (stateBelow.getTags().anyMatch(CAMPFIRE_MATCH) && ((Boolean)stateBelow.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    DangerClose.immolate(entity);
                }
            }
            if (CommonConfigValues.shouldSoulCampfireImmolate && !hasFrostWalker) {
                if (stateInside.getTags().anyMatch(SOUL_CAMPFIRE_MATCH) && ((Boolean)stateInside.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    DangerClose.immolateSoul(entity);
                } else if (stateBelow.getTags().anyMatch(SOUL_CAMPFIRE_MATCH) && ((Boolean)stateBelow.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                    DangerClose.immolateSoul(entity);
                }
            }
            if (CommonConfigValues.shouldMagmaBlockImmolate && !hasFrostWalker && !entity.isShiftKeyDown()) {
                if (stateInside.getTags().anyMatch(MAGMA_MATCH)) {
                    DangerClose.immolate(entity);
                } else if (stateBelow.getTags().anyMatch(MAGMA_MATCH)) {
                    DangerClose.immolate(entity);
                }
            }
            if (CommonConfigValues.shouldStonecutterCut && !entity.isShiftKeyDown()) {
                if (stateInside.getTags().anyMatch(STONECUTTER_MATCH)) {
                    entity.hurt(level.damageSources().generic(), 4.0f);
                } else if (stateBelow.getTags().anyMatch(STONECUTTER_MATCH)) {
                    entity.hurt(level.damageSources().generic(), 4.0f);
                }
            }
        }
        List nearby = level.getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, entity, entity.getBoundingBox());
        for (LivingEntity living : nearby) {
            DangerClose.spreadFire(entity, living);
        }
    }

    public static void immolate(LivingEntity entity) {
        entity.setRemainingFireTicks(40);
    }

    public static void immolateSoul(LivingEntity entity) {
        if (isSoulFiredLoaded && !Services.PLATFORM.getPlatformName().equalsIgnoreCase("forge")) {
            SoulFired.immolateSoul(entity);
        } else {
            DangerClose.immolate(entity);
        }
    }

    public static void spreadFire(LivingEntity entityA, LivingEntity entityB) {
        if (entityA.isOnFire() && !entityB.isOnFire()) {
            if (isSoulFiredLoaded && !Services.PLATFORM.getPlatformName().equalsIgnoreCase("forge")) {
                SoulFired.spreadTypedFire(entityA, entityB);
                return;
            }
            DangerClose.immolate(entityB);
        } else if (!entityA.isOnFire() && entityB.isOnFire()) {
            if (isSoulFiredLoaded && !Services.PLATFORM.getPlatformName().equalsIgnoreCase("forge")) {
                SoulFired.spreadTypedFire(entityA, entityB);
                return;
            }
            DangerClose.immolate(entityA);
        }
        if (CommonConfigValues.shouldBlazeImmolate && entityB instanceof Blaze) {
            DangerClose.immolate(entityA);
        }
        if (CommonConfigValues.shouldMagmaCubeImmolate && !entityA.isOnFire() && (entityB instanceof MagmaCube || entityB.getType() == EntityType.MAGMA_CUBE)) {
            DangerClose.immolate(entityA);
        }
    }
}

