/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.handler;

import fuzs.permanentsponges.PermanentSponges;
import fuzs.permanentsponges.config.ServerConfig;
import fuzs.permanentsponges.mixin.accessor.BucketItemAccessor;
import fuzs.permanentsponges.mixin.accessor.ItemAccessor;
import fuzs.permanentsponges.util.LiquidAbsorptionHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class TryEmptyBucketHandler {
    public static EventResultHolder<InteractionResult> onUseItem(Player player, Level level, InteractionHand interactionHand) {
        BlockHitResult blockHitResult;
        BucketItem item;
        Fluid fluid;
        if (!((ServerConfig)PermanentSponges.CONFIG.get(ServerConfig.class)).preventEmptyingBuckets) {
            return EventResultHolder.pass();
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        Item item2 = itemInHand.getItem();
        if (item2 instanceof BucketItem && (fluid = ((BucketItemAccessor)(item = (BucketItem)item2)).permanentsponges$getContent()) != Fluids.EMPTY && (blockHitResult = ItemAccessor.permanentsponges$callGetPlayerPOVHitResult(level, player, ClipContext.Fluid.NONE)).getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = blockHitResult.getBlockPos();
            Direction direction = blockHitResult.getDirection();
            BlockPos blockPos2 = blockPos.relative(direction);
            if (level.mayInteract(player, blockPos) && player.mayUseItemAt(blockPos2, direction, itemInHand)) {
                BlockPos blockPos3;
                BlockState blockState = level.getBlockState(blockPos);
                BlockPos blockPos4 = blockPos3 = blockState.getBlock() instanceof LiquidBlockContainer && fluid == Fluids.WATER ? blockPos : blockPos2;
                if (TryEmptyBucketHandler.emptyContents(player, level, blockPos3, blockHitResult, fluid)) {
                    item.checkExtraContent(player, level, itemInHand, blockPos3);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos3, itemInHand);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                    InteractionResultHolder result = InteractionResultHolder.sidedSuccess((Object)BucketItem.getEmptySuccessItem((ItemStack)itemInHand, (Player)player), (boolean)level.isClientSide());
                    if (itemInHand != result.getObject()) {
                        player.setItemInHand(interactionHand, (ItemStack)result.getObject());
                    }
                    return EventResultHolder.interrupt((Object)result.getResult());
                }
            }
        }
        return EventResultHolder.pass();
    }

    private static boolean emptyContents(@Nullable Player player, Level level, BlockPos blockPos, @Nullable BlockHitResult hitResult, Fluid fluid) {
        ServerLevel serverLevel;
        boolean bl2;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        boolean bl = blockState.canBeReplaced(fluid);
        boolean bl3 = bl2 = blockState.isAir() || bl || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, blockPos, blockState, fluid);
        if (!bl2) {
            return hitResult != null && TryEmptyBucketHandler.emptyContents(player, level, hitResult.getBlockPos().relative(hitResult.getDirection()), null, fluid);
        }
        if (level instanceof ServerLevel && LiquidAbsorptionHelper.tryPreventLiquidFromEntering(serverLevel = (ServerLevel)level, blockPos, fluid)) {
            LiquidAbsorptionHelper.removeLiquidEffects(level, blockPos, fluid);
            return true;
        }
        return false;
    }
}

