/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.overclocked_watches;

import common.com.cursee.overclocked_watches.core.ConfiguredValues;
import common.com.cursee.overclocked_watches.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class OverclockedWatchesUtil {
    public static void addGoldenGrowthParticles(ServerLevel level, BlockPos blockPos, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            level.sendParticles((ParticleOptions)Services.PLATFORM.getGoldenWatchGrowthParticle(), (double)blockPos.getX() + level.random.nextDouble(), (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.2);
        }
    }

    public static void addDiamondGrowthParticles(ServerLevel level, BlockPos blockPos, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            level.sendParticles((ParticleOptions)Services.PLATFORM.getDiamondWatchGrowthParticle(), (double)blockPos.getX() + level.random.nextDouble(), (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.2);
        }
    }

    public static void addNetheriteGrowthParticles(ServerLevel level, BlockPos blockPos, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            level.sendParticles((ParticleOptions)Services.PLATFORM.getNetheriteWatchGrowthParticle(), (double)blockPos.getX() + level.random.nextDouble(), (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.2);
        }
    }

    public static boolean handleNetheriteWatchTag(ItemStack itemStack) {
        int currentCharges;
        CompoundTag baseTag = itemStack.getOrCreateTag();
        if (!baseTag.contains("charges")) {
            baseTag.put("charges", (Tag)IntTag.valueOf((int)((int)ConfiguredValues.NETHERITE_WATCH_CHARGES.get())));
        }
        if ((currentCharges = baseTag.getInt("charges")) > 0) {
            baseTag.put("charges", (Tag)IntTag.valueOf((int)(--currentCharges)));
            return true;
        }
        return false;
    }

    public static boolean handleDiamondWatchTag(ItemStack itemStack) {
        int currentCharges;
        CompoundTag baseTag = itemStack.getOrCreateTag();
        if (!baseTag.contains("charges")) {
            baseTag.put("charges", (Tag)IntTag.valueOf((int)((int)ConfiguredValues.DIAMOND_WATCH_CHARGES.get())));
        }
        if ((currentCharges = baseTag.getInt("charges")) > 0) {
            baseTag.put("charges", (Tag)IntTag.valueOf((int)(--currentCharges)));
            return true;
        }
        return false;
    }

    public static boolean handleGoldenWatchTag(ItemStack itemStack) {
        int currentCharges;
        CompoundTag baseTag = itemStack.getOrCreateTag();
        if (!baseTag.contains("charges")) {
            baseTag.put("charges", (Tag)IntTag.valueOf((int)((int)ConfiguredValues.GOLDEN_WATCH_CHARGES.get())));
        }
        if ((currentCharges = baseTag.getInt("charges")) > 0) {
            baseTag.put("charges", (Tag)IntTag.valueOf((int)(--currentCharges)));
            return true;
        }
        return false;
    }
}

