/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.overclocked_watches.core.item.custom;

import fabric.com.cursee.overclocked_watches.core.ConfiguredValues;
import fabric.com.cursee.overclocked_watches.platform.Services;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class WatchItem
extends class_1792 {
    public static final String CHARGES = "charges";
    private static final int GOLDEN_CHARGES = (int)ConfiguredValues.GOLDEN_WATCH_CHARGES.get();
    private static final int DIAMOND_CHARGES = (int)ConfiguredValues.DIAMOND_WATCH_CHARGES.get();
    private static final int NETHERITE_CHARGES = (int)ConfiguredValues.NETHERITE_WATCH_CHARGES.get();
    private final Tier tier;

    public WatchItem(Tier tier) {
        super(new class_1792.class_1793().method_7895(tier.getItemDurability()));
        this.tier = tier;
    }

    public class_1799 method_7854() {
        class_1799 itemStack = new class_1799((class_1935)this);
        class_2487 stackData = itemStack.method_7948();
        if (stackData.method_10573(CHARGES, 3)) {
            return itemStack;
        }
        switch (this.getTier()) {
            case GOLDEN: {
                stackData.method_10569(CHARGES, GOLDEN_CHARGES);
            }
            case DIAMOND: {
                stackData.method_10569(CHARGES, DIAMOND_CHARGES);
            }
            case NETHERITE: {
                stackData.method_10569(CHARGES, NETHERITE_CHARGES);
            }
        }
        itemStack.method_7953(stackData);
        return itemStack.method_7972();
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 tooltipFlag) {
        class_2487 stackData = itemStack.method_7948();
        if (!stackData.method_10573(CHARGES, 3)) {
            switch (((WatchItem)itemStack.method_7909()).getTier()) {
                case GOLDEN: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{GOLDEN_CHARGES}));
                    break;
                }
                case DIAMOND: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{DIAMOND_CHARGES}));
                    break;
                }
                case NETHERITE: {
                    tooltip.add((class_2561)class_2561.method_43469((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{NETHERITE_CHARGES}));
                }
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"text.overclocked_watches.charges", (Object[])new Object[]{stackData.method_10550(CHARGES)}));
        }
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int slotIndex, boolean slotSelected) {
        class_2487 stackData = itemStack.method_7948();
        if (stackData.method_10573(CHARGES, 3)) {
            return;
        }
        switch (((WatchItem)itemStack.method_7909()).getTier()) {
            case GOLDEN: {
                stackData.method_10569(CHARGES, GOLDEN_CHARGES);
                break;
            }
            case DIAMOND: {
                stackData.method_10569(CHARGES, DIAMOND_CHARGES);
                break;
            }
            case NETHERITE: {
                stackData.method_10569(CHARGES, NETHERITE_CHARGES);
            }
        }
    }

    public static void applyCooldowns(class_1657 player, int lengthInTicks) {
        player.method_7357().method_7906(Services.PLATFORM.getRegisteredNetheriteWatchItem().get(), lengthInTicks);
        player.method_7357().method_7906(Services.PLATFORM.getRegisteredDiamondWatchItem().get(), lengthInTicks);
        player.method_7357().method_7906(Services.PLATFORM.getRegisteredGoldenWatchItem().get(), lengthInTicks);
    }

    public static class_1799 initializeTag(class_1799 itemStack) {
        class_2487 stackData = itemStack.method_7948();
        if (stackData.method_10573(CHARGES, 3)) {
            return itemStack;
        }
        switch (((WatchItem)itemStack.method_7909()).getTier()) {
            case GOLDEN: {
                stackData.method_10569(CHARGES, GOLDEN_CHARGES);
                break;
            }
            case DIAMOND: {
                stackData.method_10569(CHARGES, DIAMOND_CHARGES);
                break;
            }
            case NETHERITE: {
                stackData.method_10569(CHARGES, NETHERITE_CHARGES);
            }
        }
        itemStack.method_7953(stackData);
        return itemStack.method_7972();
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_3218 serverLevel;
        class_1799 itemInHand;
        block17: {
            block16: {
                itemInHand = player.method_5998(hand);
                if (!(level instanceof class_3218)) break block16;
                serverLevel = (class_3218)level;
                if (player instanceof class_3222) break block17;
            }
            return class_1271.method_22430((Object)itemInHand);
        }
        class_3222 serverPlayer = (class_3222)player;
        class_2487 unvalidatedStackData = itemInHand.method_7948();
        if (!unvalidatedStackData.method_10573(CHARGES, 3)) {
            itemInHand = WatchItem.initializeTag(itemInHand);
        } else if (unvalidatedStackData.method_10550(CHARGES) == 0) {
            return class_1271.method_22430((Object)itemInHand);
        }
        switch (this.getTier()) {
            case GOLDEN: {
                serverLevel.method_29199((serverLevel.method_8532() + ConfiguredValues.GOLDEN_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                break;
            }
            case DIAMOND: {
                serverLevel.method_29199((serverLevel.method_8532() + ConfiguredValues.DIAMOND_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                break;
            }
            case NETHERITE: {
                serverLevel.method_29199((serverLevel.method_8532() + ConfiguredValues.NETHERITE_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
            }
        }
        class_2487 validatedStackData = itemInHand.method_7948();
        int newChargeCount = validatedStackData.method_10550(CHARGES) - 1;
        validatedStackData.method_10551(CHARGES);
        validatedStackData.method_10569(CHARGES, newChargeCount);
        itemInHand.method_7953(validatedStackData);
        switch (this.getTier()) {
            case GOLDEN: {
                WatchItem.applyCooldowns((class_1657)serverPlayer, 1200 * (int)ConfiguredValues.GOLDEN_WATCH_COOLDOWN_MINUTES.get());
                break;
            }
            case DIAMOND: {
                WatchItem.applyCooldowns((class_1657)serverPlayer, 1200 * (int)ConfiguredValues.DIAMOND_WATCH_COOLDOWN_MINUTES.get());
                break;
            }
            case NETHERITE: {
                WatchItem.applyCooldowns((class_1657)serverPlayer, 1200 * (int)ConfiguredValues.NETHERITE_WATCH_COOLDOWN_MINUTES.get());
            }
        }
        return class_1271.method_22427((Object)itemInHand);
    }

    public Tier getTier() {
        return this.tier;
    }

    public static enum Tier {
        GOLDEN(ConfiguredValues.GOLDEN_WATCH_DURABILITY.get()),
        DIAMOND(ConfiguredValues.DIAMOND_WATCH_DURABILITY.get()),
        NETHERITE(ConfiguredValues.NETHERITE_WATCH_DURABILITY.get());

        private final long itemDurability;

        private Tier(long itemDurability) {
            this.itemDurability = itemDurability;
        }

        public int getItemDurability() {
            return (int)this.itemDurability;
        }
    }
}

