/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.mixin;

import forge.com.cursee.overclocked_watches.OverclockedWatchesUtil;
import forge.com.cursee.overclocked_watches.platform.Services;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public class ForgeMobMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void injected_$_onTick(CallbackInfo callbackInfo) {
        Mob instanceMob = (Mob)this;
        Level instanceLevel = instanceMob.m_9236_();
        if (!(instanceMob instanceof AgeableMob) || !(instanceLevel instanceof ServerLevel)) {
            return;
        }
        AgeableMob mob = (AgeableMob)instanceMob;
        ServerLevel level = (ServerLevel)instanceLevel;
        if (level.m_46467_() % 20L != 0L || mob.f_146733_ >= 0) {
            return;
        }
        AABB SEARCH_AREA = new AABB(mob.m_20183_()).m_82377_(4.0, 1.0, 4.0);
        List nearbyPlayers = level.m_45976_(Player.class, SEARCH_AREA);
        AtomicBoolean FOUND_GOLDEN_WATCH = new AtomicBoolean(false);
        AtomicBoolean FOUND_DIAMOND_WATCH = new AtomicBoolean(false);
        AtomicBoolean FOUND_NETHERITE_WATCH = new AtomicBoolean(false);
        nearbyPlayers.forEach(player -> {
            ItemStack equippedWatch;
            if (Services.PLATFORM.playerHasGoldenWatchEquipped((Player)player)) {
                FOUND_GOLDEN_WATCH.set(true);
            }
            if (Services.PLATFORM.playerHasDiamondWatchEquipped((Player)player)) {
                FOUND_DIAMOND_WATCH.set(true);
            }
            if (Services.PLATFORM.playerHasNetheriteWatchEquipped((Player)player)) {
                FOUND_NETHERITE_WATCH.set(true);
            }
            if (FOUND_NETHERITE_WATCH.get() && player.m_217043_().m_216339_(0, 20) == 1) {
                equippedWatch = Services.PLATFORM.getEquippedNetheriteWatch((Player)player);
                equippedWatch.m_220157_(1, player.m_217043_(), (ServerPlayer)player);
                if (equippedWatch.m_41773_() >= equippedWatch.m_41776_()) {
                    equippedWatch.m_41774_(1);
                }
            }
            if (FOUND_DIAMOND_WATCH.get() && player.m_217043_().m_216339_(0, 20) == 1) {
                equippedWatch = Services.PLATFORM.getEquippedDiamondWatch((Player)player);
                equippedWatch.m_220157_(1, player.m_217043_(), (ServerPlayer)player);
                if (equippedWatch.m_41773_() >= equippedWatch.m_41776_()) {
                    equippedWatch.m_41774_(1);
                }
            }
            if (FOUND_GOLDEN_WATCH.get() && player.m_217043_().m_216339_(0, 20) == 1) {
                equippedWatch = Services.PLATFORM.getEquippedGoldenWatch((Player)player);
                equippedWatch.m_220157_(1, player.m_217043_(), (ServerPlayer)player);
                if (equippedWatch.m_41773_() >= equippedWatch.m_41776_()) {
                    equippedWatch.m_41774_(1);
                }
            }
        });
        if (!(FOUND_GOLDEN_WATCH.get() || FOUND_DIAMOND_WATCH.get() || FOUND_NETHERITE_WATCH.get())) {
            return;
        }
        if (FOUND_NETHERITE_WATCH.get()) {
            mob.m_146758_(240);
            OverclockedWatchesUtil.addNetheriteGrowthParticles(level, mob.m_20183_(), 8);
        } else if (FOUND_DIAMOND_WATCH.get()) {
            mob.m_146758_(30);
            OverclockedWatchesUtil.addDiamondGrowthParticles(level, mob.m_20183_(), 8);
        } else if (FOUND_GOLDEN_WATCH.get()) {
            mob.m_146758_(5);
            OverclockedWatchesUtil.addGoldenGrowthParticles(level, mob.m_20183_(), 8);
        }
    }
}

