/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.BlockHighlightDrawEvent;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.HorizontalSlabConverter;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.mixin.LevelRendererAccessor;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KleeSlabsClient {
    public static void initialize() {
        Balm.getEvents().onEvent(BlockHighlightDrawEvent.class, KleeSlabsClient::onDrawBlockHighlight);
    }

    private static void onDrawBlockHighlight(BlockHighlightDrawEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !KleeSlabs.isPlayerKleeSlabbing((Player)player)) {
            return;
        }
        BlockHitResult hitResult = event.getHitResult();
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = hitResult.m_82425_();
        BlockState state = player.m_9236_().m_8055_(pos);
        SlabConverter slabConverter = SlabRegistry.getSlabConverter(state.m_60734_());
        if (slabConverter instanceof HorizontalSlabConverter && slabConverter.isDoubleSlab(state)) {
            AABB halfAABB = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)pos.m_123342_() + 0.5, (double)(pos.m_123343_() + 1));
            if (hitResult.m_82450_().f_82480_ - (double)pos.m_123342_() > 0.5) {
                halfAABB = halfAABB.m_82386_(0.0, 0.5, 0.0);
            }
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource buffers = event.getMultiBufferSource();
            VertexConsumer vertexBuilder = buffers.m_6299_((RenderType)RenderType.f_110371_);
            VoxelShape shape = Shapes.m_83064_((AABB)halfAABB.m_82400_(0.002));
            Camera camera = event.getCamera();
            double camX = camera.m_90583_().f_82479_;
            double camY = camera.m_90583_().f_82480_;
            double camZ = camera.m_90583_().f_82481_;
            LevelRendererAccessor.callRenderShape(poseStack, vertexBuilder, shape, -camX, -camY, -camZ, 0.0f, 0.0f, 0.0f, 0.4f);
            event.setCanceled(true);
        }
    }
}

