/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectedWindow
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final EnumProperty<ConnectionStatus> PART = EnumProperty.m_61587_((String)"part", ConnectionStatus.class);
    protected static final VoxelShape EE = ConnectedWindow.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = ConnectedWindow.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    private boolean wasInteractedWith = false;

    public ConnectedWindow(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? NN : EE;
    }

    protected BlockState WindowState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        boolean north = level.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = level.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = level.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = level.m_8055_(pos.m_122024_()).m_60734_() == this;
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                if (!above && below) {
                    if (east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP_R));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP));
                }
                if (above && below) {
                    if (east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MID_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MID_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MID_R));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MIDDLE));
                }
                if (above && !below) {
                    if (east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOT_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOT_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOT_R));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOTTOM));
                }
                if (!above && !below) {
                    if (east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.SINGLE_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.SINGLE_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.SINGLE_R));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BASE));
                }
            }
            case EAST: {
                if (!above && below) {
                    if (north && south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP_L));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.TOP));
                }
                if (above && below) {
                    if (north && south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MID_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MID_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MID_L));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.MIDDLE));
                }
                if (above && !below) {
                    if (north && south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOT_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOT_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOT_L));
                    }
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BOTTOM));
                }
                if (above || below) break;
                if (north && south) {
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.SINGLE_M));
                }
                if (!north && south) {
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.SINGLE_R));
                }
                if (north && !south) {
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.SINGLE_L));
                }
                return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BASE));
            }
        }
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)ConnectionStatus.BASE));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item == ItemInit.HAMMER.get() || item == Items.f_42574_) {
            BlockState newState = (BlockState)state.m_61122_(PART);
            level.m_46597_(pos, newState);
            this.setWasInteractedWith(true, level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setWasInteractedWith(boolean interacted, Level level, BlockPos pos) {
        this.wasInteractedWith = interacted;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            level.m_7731_(pos, this.WindowState(state, (LevelAccessor)level, pos), 2);
            this.wasInteractedWith = false;
        }
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        if (this.wasInteractedWith) {
            return state;
        }
        return this.WindowState(state, access, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext contx) {
        Direction facingDirection = contx.m_8125_();
        Level world = contx.m_43725_();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        return (BlockState)this.WindowState(super.m_5573_(contx), (LevelAccessor)world, contx.m_8083_()).m_61124_((Property)FACING, (Comparable)facingDirection);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        TOP_L("top_l"),
        TOP_M("top_m"),
        TOP_R("top_r"),
        MID_L("mid_l"),
        MID_M("mid_m"),
        MID_R("mid_r"),
        BOT_L("bot_l"),
        BOT_M("bot_m"),
        BOT_R("bot_r"),
        SINGLE_L("single_l"),
        SINGLE_M("single_m"),
        SINGLE_R("single_r");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

