/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.block.entity;

import java.util.List;
import net.Pandarix.betterarcheology.BetterArcheologyConfig;
import net.Pandarix.betterarcheology.block.custom.RadianceTotemBlock;
import net.Pandarix.betterarcheology.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RadianceTotemBlockEntity
extends BlockEntity {
    public RadianceTotemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RADIANCE_TOTEM.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, RadianceTotemBlockEntity blockEntity) {
        if (!BetterArcheologyConfig.radianceTotemEnabled.get().booleanValue() || !BetterArcheologyConfig.totemsEnabled.get().booleanValue()) {
            return;
        }
        if (world.m_213780_().m_216332_(1, 10) == 1) {
            int totemRadius = BetterArcheologyConfig.radianceTotemRadius.get() * 2;
            List livingEntities = world.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)totemRadius, (double)totemRadius, (double)totemRadius));
            RadianceTotemBlockEntity.applyGlowingEffect(livingEntities, state);
            if (BetterArcheologyConfig.radianceTotemDamageEnabled.get().booleanValue() && world.m_213780_().m_216332_(1, BetterArcheologyConfig.radianceTotemDamageTickAverage.get() * 2) == 1) {
                for (LivingEntity livingEntity : livingEntities) {
                    if (!(livingEntity instanceof Monster)) continue;
                    Monster monster = (Monster)livingEntity;
                    monster.m_6469_(monster.m_269291_().m_269425_(), (float)BetterArcheologyConfig.radianceTotemDamage.get().intValue());
                    world.m_6263_(null, monster.m_20182_().m_7096_(), monster.m_20182_().m_7098_(), monster.m_20182_().m_7094_(), SoundEvents.f_144245_, SoundSource.HOSTILE, 0.5f, 0.5f);
                }
            }
        }
    }

    private static void applyGlowingEffect(List<LivingEntity> livingEntities, BlockState state) {
        int selector = 0;
        if (state.m_60734_() instanceof RadianceTotemBlock) {
            selector = (Integer)state.m_61143_((Property)RadianceTotemBlock.SELECTOR);
        }
        Class<?> filteredClass = RadianceTotemBlockEntity.getFilteredEntityClass(selector);
        livingEntities.forEach(livingEntity -> {
            if (filteredClass.isInstance(livingEntity)) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0, false, false));
            }
        });
    }

    private static Class<?> getFilteredEntityClass(int selector) {
        return switch (selector) {
            case 1 -> Monster.class;
            case 2 -> Animal.class;
            case 3 -> Player.class;
            default -> LivingEntity.class;
        };
    }
}

