/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageUpgradePerk;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenKnowledge
extends TBScreen {
    private static final ResourceLocation BOOK_PART = new ResourceLocation("tombstone", "textures/item/book_part1.png");
    private final LocalPlayer player;
    private final ITBCapability cap;
    private final int upgradableLevelMax;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private final ItemStack stackSkull = ItemAdvancement.IconType.FIRST_KNOWLEDGE.getItemStack();
    private final ItemStack stackRevive = ItemAdvancement.IconType.REVIVE.getItemStack();
    private final ItemStack stackAnkh = ItemAdvancement.IconType.FIRST_PRAY.getItemStack();
    private final double alignmentPos;
    private final List<BonusIcon> bonusIcons = new ArrayList<BonusIcon>();
    private static final int PERK_AREA_WIDTH = 330;
    private static final int PERK_AREA_HEIGHT = 100;
    private static final int PERK_AREA_DRAG_LIMIT_X = 0;
    private static final int PERK_AREA_DRAG_LIMIT_Y = 0;
    private int perkAreaMinX;
    private int perkAreaMinY;
    private boolean isDraggingPerkArea = false;
    private boolean isClickingPerkArea = false;
    private int perkAreaDragOffsetX = 0;
    private int perkAreaDragOffsetY = 0;
    private int lastMouseX;
    private int lastMouseY;
    private int clickedX;
    private int clickedY;

    public ScreenKnowledge(LocalPlayer player, ITBCapability cap) {
        super((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.player = player;
        this.cap = cap;
        this.upgradableLevelMax = cap.getTotalPerkPoints();
        PerkRegistry.values().forEach(perk -> this.icons.add(new PerkIcon((Perk)perk)));
        this.alignmentPos = this.getBarRatio();
        this.initBonusIcons(this.cap);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.perkAreaMinX = (this.f_96543_ - 330) / 2;
        this.perkAreaMinY = this.guiTop + 80;
        int i = 0;
        int spaceForIcon = 33;
        int maxIconByLine = 10;
        int x = 0;
        int y = 0;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setLocalPosition(x + caseX * spaceForIcon + 5, y + i / maxIconByLine * 40);
            ++i;
        }
        int xIcon = this.guiLeft + 30;
        for (BonusIcon icon : this.bonusIcons) {
            icon.setPosition(xIcon, this.guiBottom - 45);
            xIcon += 18;
        }
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]), pressable -> this.getMinecraft().m_91152_((Screen)new ScreenCompendium())));
        this.m_142416_((GuiEventListener)new CustomButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_CONFIG.getText(new Object[0]), pressable -> this.getMinecraft().m_91152_((Screen)new ScreenConfig())));
    }

    private void initBonusIcons(ITBCapability cap) {
        ArrayList tooltips;
        int alignmentLevel;
        boolean isBad;
        TimeHelper.SpecialEvent specialEvent = TimeHelper.getSpecialEvent();
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            String eventName;
            this.bonusIcons.add(new BonusIcon(switch (specialEvent) {
                case TimeHelper.SpecialEvent.HALLOWEEN -> {
                    eventName = "halloween";
                    yield ItemAdvancement.IconType.GHOST.getItemStack();
                }
                case TimeHelper.SpecialEvent.CHRISTMAS -> {
                    eventName = "christmas";
                    yield new ItemStack((ItemLike)ModItems.christmas_gift);
                }
                default -> {
                    eventName = "spring_bloom";
                    yield new ItemStack((ItemLike)Items.f_42209_);
                }
            }, Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("tombstone.compendium." + eventName + ".title")).m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"tombstone.message.holiday_event_bonus")})));
        }
        if ((isBad = (alignmentLevel = cap.getAlignmentLevel()) < 0) || alignmentLevel > 0) {
            tooltips = new ArrayList();
            tooltips.add((isBad ? LangKey.MESSAGE_DARKNESS : LangKey.MESSAGE_LIGHT).getText(StyleType.MESSAGE_SPECIAL, new Object[]{Helper.getRomanNumber(Math.abs(alignmentLevel))}));
            tooltips.add(Component.m_237110_((String)"tombstone.message.protect_against", (Object[])new Object[]{Component.m_237115_((String)("tombstone.message." + (isBad ? "living_damages" : "undead_damages"))), Math.abs(alignmentLevel * 10)}));
            this.bonusIcons.add(new BonusIcon(isBad ? this.stackSkull : this.stackRevive, tooltips));
        }
        tooltips = isBad ? Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tombstone.advancement.zombify.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.zombify")}) : Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.exorcism.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.exorcism")});
        this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.EXORCISM.getItemStack(), tooltips));
        if (alignmentLevel > 0) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.PRAY_OF_PROTECTION.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tombstone.advancement.pray_of_protection.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.pray_of_protection")})));
        }
        if (alignmentLevel > 2) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.GOLD_HEART.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.pray_of_harmonization.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.pray_of_harmonization")})));
        } else if (alignmentLevel > 1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.f_42655_), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.pray_of_empathy.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.pray_of_empathy")})));
        }
        if (alignmentLevel < -2) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.BLACK_NOTE.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.pray_of_dissonance.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.pray_of_dissonance")})));
        } else if (alignmentLevel < -1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.f_42586_), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.pray_of_undead.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.pray_of_undead")})));
        }
        if (cap.hasWatcherKnowledge(0)) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.SPECTRAL_BOND.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.rite_of_silent_bond.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.rite_of_silent_bond")})));
        }
        if (cap.hasWatcherKnowledge(1)) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.WING.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.enhanced_grave_prayer.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.enhanced_grave_prayer")})));
        }
        if (cap.hasWatcherKnowledge(2)) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.f_42291_), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.rite_of_coral_chant.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.rite_of_coral_chant")})));
        }
        if (cap.hasWatcherKnowledge(3)) {
            this.bonusIcons.add(new BonusIcon(ModItems.scroll_of_knowledge.createWithXp(1), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.rite_of_remanence.title").m_130948_(StyleType.MESSAGE_SPECIAL), Component.m_237115_((String)"bonus.tombstone.rite_of_remanence")})));
        }
        this.bonusIcons.forEach(bonusIcon -> bonusIcon.tooltips.replaceAll(FontHelper::withFantasyFont));
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.isDraggingPerkArea = false;
        this.clickedX = this.lastMouseX = (int)mouseX;
        this.clickedY = this.lastMouseY = (int)mouseY;
        boolean bl = this.isClickingPerkArea = mouseX >= (double)this.perkAreaMinX && mouseX <= (double)(this.perkAreaMinX + 330) && mouseY >= (double)this.perkAreaMinY && mouseY <= (double)(this.perkAreaMinY + 100);
        if (this.isClickingPerkArea) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (mouseButton == 0 && this.isClickingPerkArea) {
            if (!this.isDraggingPerkArea) {
                int distX = Math.abs((int)mouseX - this.clickedX);
                int distY = Math.abs((int)mouseY - this.clickedY);
                if (distX > 2 || distY > 2) {
                    this.isDraggingPerkArea = true;
                }
            }
            if (this.isDraggingPerkArea) {
                this.perkAreaDragOffsetX = Mth.m_14045_((int)(this.perkAreaDragOffsetX + (int)(mouseX - (double)this.lastMouseX)), (int)0, (int)0);
                this.perkAreaDragOffsetY = Mth.m_14045_((int)(this.perkAreaDragOffsetY + (int)(mouseY - (double)this.lastMouseY)), (int)0, (int)0);
                this.lastMouseX = (int)mouseX;
                this.lastMouseY = (int)mouseY;
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isDraggingPerkArea) {
            this.isDraggingPerkArea = false;
            this.lastMouseX = 0;
            this.lastMouseY = 0;
            return true;
        }
        if (this.hoveredIcon != null) {
            if (mouseButton == 0 && !this.hoveredIcon.perk.isDisabled((Player)this.player)) {
                int perkLevel = this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk);
                if (perkLevel < Math.min(this.hoveredIcon.perk.getLevelMax(), this.upgradableLevelMax) && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.player.m_7500_() && this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.drawTitle(guiGraphics, (Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((Player)this.player);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        int playerKnowledge = this.cap.getKnowledge();
        int currentLevelKnowledge = this.cap.getKnowledgeForLevel(totalPerkPoints);
        int nextLevelKnowledge = this.cap.getKnowledgeForLevel(totalPerkPoints + 1);
        int knowledgeBarStartX = this.guiLeft + 10;
        int knowledgeBarEndX = this.halfWidth - 10;
        int knowledgeBarWidth = knowledgeBarEndX - knowledgeBarStartX;
        guiGraphics.m_280430_(this.f_96547_, FontHelper.withFantasyFont((Component)LangKey.MESSAGE_KNOWLEDGE_LEVEL.getText(totalPerkPoints)), this.guiLeft + 15, this.guiTop + 40, -1);
        guiGraphics.m_280430_(this.f_96547_, FontHelper.withSmallFantasyFont((Component)LangKey.MESSAGE_AVAILABLE_POINTS.getText(this.leftPerkPoints)), this.guiLeft + 100, this.guiTop + 40, -1);
        guiGraphics.m_280430_(this.f_96547_, FontHelper.withSmallFantasyFont((Component)LangKey.MESSAGE_NEXT_LEVEL.getText(playerKnowledge - currentLevelKnowledge, nextLevelKnowledge - currentLevelKnowledge)), this.guiLeft + 100, this.guiTop + 48, -1);
        int percentFilled = Math.round((float)(knowledgeBarWidth * (playerKnowledge - currentLevelKnowledge)) / (float)(nextLevelKnowledge - currentLevelKnowledge));
        guiGraphics.m_280509_(this.guiLeft + 9, this.guiTop + 54, this.halfWidth - 9, this.guiTop + 61, -16777216);
        guiGraphics.m_280509_(knowledgeBarStartX, this.guiTop + 55, knowledgeBarEndX, this.guiTop + 60, -1875);
        guiGraphics.m_280509_(knowledgeBarStartX, this.guiTop + 55, percentFilled, this.guiTop + 60, -16711936);
        float step = (float)knowledgeBarWidth / 8.0f;
        for (int i = 1; i < 8; ++i) {
            guiGraphics.m_280315_(knowledgeBarStartX + (int)((float)i * step), this.guiTop + 54, this.guiTop + 60, -16777216);
        }
        int alignmentBarStartX = this.halfWidth + 10;
        int alignmentBarEndX = this.guiRight - 10;
        int alignmentBarWidth = alignmentBarEndX - alignmentBarStartX;
        int alignmentBarCenterX = alignmentBarStartX + alignmentBarWidth / 2;
        int alignmentLevel = this.cap.getAlignmentLevel();
        guiGraphics.m_280430_(this.f_96547_, FontHelper.withFantasyFont((Component)LangKey.MESSAGE_ALIGNMENT_LEVEL.getText((alignmentLevel < 0 ? "-" : "+") + alignmentLevel)), this.halfWidth + 15, this.guiTop + 40, -1);
        guiGraphics.m_280509_(this.halfWidth + 9, this.guiTop + 54, this.guiRight - 9, this.guiTop + 61, -16777216);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        Helper.fillGradient(matrix, alignmentBarStartX, this.guiTop + 55, alignmentBarCenterX, this.guiTop + 60, -65536, -1875, 0, true);
        Helper.fillGradient(matrix, alignmentBarCenterX, this.guiTop + 55, alignmentBarEndX, this.guiTop + 60, -1875, -16776961, 0, true);
        step = (float)alignmentBarWidth / 8.0f;
        for (int i = 1; i < 8; ++i) {
            if (i == 4) continue;
            guiGraphics.m_280315_(alignmentBarStartX + (int)((float)i * step), this.guiTop + 54, this.guiTop + 60, -16777216);
        }
        float scale = 0.6f;
        float inverseScale = 1.0f / scale;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int itemY = Math.round((float)(this.guiTop + 52) * inverseScale);
        guiGraphics.m_280480_(this.stackSkull, Math.round((float)(alignmentBarStartX - 4) * inverseScale), itemY);
        guiGraphics.m_280480_(this.stackRevive, Math.round((float)(alignmentBarEndX - 4) * inverseScale), itemY);
        guiGraphics.m_280480_(this.stackAnkh, (int)Math.round(((double)alignmentBarCenterX + (double)((float)alignmentBarWidth * 0.5f) * this.alignmentPos - 4.0) * (double)inverseScale), itemY);
        guiGraphics.m_280168_().m_85849_();
        for (PerkIcon icon2 : this.icons) {
            icon2.updatePosition(this.perkAreaDragOffsetX, this.perkAreaDragOffsetY, this.perkAreaMinX, this.perkAreaMinY);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.perkAreaDragOffsetX, (float)this.perkAreaDragOffsetY, 0.0f);
        guiGraphics.m_280588_(this.perkAreaMinX, this.perkAreaMinY, this.perkAreaMinX + 330, this.perkAreaMinY + 100);
        this.hoveredIcon = this.icons.stream().filter(icon -> icon.contains(mouseX - this.perkAreaDragOffsetX, mouseY - this.perkAreaDragOffsetY)).findFirst().orElse(null);
        this.icons.forEach(icon -> this.drawPerk(guiGraphics, (PerkIcon)icon));
        guiGraphics.m_280618_();
        guiGraphics.m_280168_().m_85849_();
        this.bonusIcons.forEach(icon -> icon.render(guiGraphics));
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.hoveredIcon != null) {
            if (!this.isDraggingPerkArea) {
                this.drawPerkTooltip(guiGraphics);
            }
        } else {
            this.bonusIcons.stream().filter(icon -> icon.contains(mouseX, mouseY)).findFirst().ifPresent(icon -> guiGraphics.m_280666_(this.f_96547_, icon.tooltips, icon.minX + 10, icon.minY + 10));
        }
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignment = Math.abs(Mth.m_14045_((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignment > 3000 ? 0.75 + 0.25 * (double)(alignment - 3000) * 5.0E-4 : (alignment > 1500 ? 0.5 + 0.25 * (double)(alignment - 1500) / 1500.0 : (alignment > 500 ? 0.25 + 0.25 * (double)(alignment - 500) * 0.001 : 0.25 * (double)alignment * 0.002));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(GuiGraphics guiGraphics, PerkIcon icon) {
        boolean isGray;
        int baseLevel = this.cap.getPerkLevel((Player)this.player, icon.perk);
        int levelWithBonus = this.cap.getPerkLevelWithBonus((Player)this.player, icon.perk);
        boolean isHovered = icon.equals(this.hoveredIcon);
        boolean isMax = baseLevel == icon.perk.getLevelMax();
        boolean isDisabled = icon.perk.isDisabled((Player)this.player);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280509_(icon.minX, icon.minY + 25 - 1, icon.maxX - 1, icon.maxY, -15329733);
        boolean bl = isGray = isDisabled || levelWithBonus == 0 && !isHovered;
        if (isGray) {
            RenderSystem.setShaderColor((float)0.13f, (float)0.13f, (float)0.13f, (float)0.13f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280163_(FRAME, icon.minX, icon.minY, 0.0f, 0.0f, 24, 24, 24, 24);
        guiGraphics.m_280163_(icon.perk.getIcon(), icon.minX + 2, icon.minY + 2, 0.0f, 0.0f, 20, 20, 20, 20);
        if (icon.perk.equals(ModPerks.scribe)) {
            if (!isGray) {
                RenderSystem.setShaderColor((float)0.4117647f, (float)0.45882353f, (float)0.5176471f, (float)1.0f);
            }
            guiGraphics.m_280163_(BOOK_PART, icon.minX + 2, icon.minY + 2, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isHovered) {
            int color = isDisabled ? -65536 : (isMax ? -1980292 : -7096363);
            guiGraphics.m_280656_(icon.minX - 1, icon.maxX - 1, icon.minY - 1, color);
            guiGraphics.m_280656_(icon.minX - 1, icon.maxX - 1, icon.maxY, color);
            guiGraphics.m_280315_(icon.minX - 1, icon.minY - 1, icon.maxY, color);
            guiGraphics.m_280315_(icon.maxX - 1, icon.minY - 1, icon.maxY, color);
        }
        boolean hasBonus = icon.perk.getLevelBonus((Player)this.player) != 0;
        MutableComponent perkLevelText = Component.m_237113_((String)("" + baseLevel)).m_6270_(isDisabled ? StyleType.COLOR_RED : (isMax ? StyleType.PERK_TEXT_MAX : (baseLevel > 0 ? StyleType.PERK_TEXT_DEFAULT : StyleType.PERK_TEXT_DISABLE)));
        if (hasBonus && !isDisabled) {
            perkLevelText.m_7220_((Component)Component.m_237113_((String)("(" + levelWithBonus + ")")).m_130948_(StyleType.PERK_TEXT_BONUS));
        }
        FontHelper.drawCenteredFantasy(guiGraphics, this.f_96547_, (Component)perkLevelText, (float)(icon.minX + icon.maxX) / 2.0f, icon.maxY - 8, -1);
    }

    private void drawPerkTooltip(GuiGraphics guiGraphics) {
        if (this.hoveredIcon != null) {
            int baseLevel = this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((Player)this.player, this.hoveredIcon.perk);
            int levelMax = this.hoveredIcon.perk.getLevelMax();
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(this.hoveredIcon.perk.getTranslation().m_6881_().m_130948_(StyleType.MESSAGE_SPECIAL));
            list.add(Component.m_237115_((String)(this.hoveredIcon.perk.getTranslationKey() + ".desc")).m_130940_(ChatFormatting.DARK_GRAY));
            list.add(LangKey.TOOLTIP_ACTUAL_BONUS.getText(new Object[0]).m_130948_(StyleType.INFO));
            ChatFormatting chatFormatting = levelWithBonus > baseLevel ? ChatFormatting.DARK_PURPLE : ChatFormatting.WHITE;
            this.hoveredIcon.perk.getCurrentBonusInfo(levelWithBonus).forEach(info -> list.add(info.m_6881_().m_130940_(chatFormatting)));
            if (this.hoveredIcon.perk.isDisabled((Player)this.player)) {
                list.add(this.hoveredIcon.perk.getDisabledInfo((Player)this.player).m_6879_().m_6270_(StyleType.COLOR_RED));
            } else if (baseLevel < levelMax) {
                int cost;
                if (levelWithBonus < levelMax) {
                    list.add(LangKey.TOOLTIP_NEXT_BONUS.getText(new Object[0]).m_130948_(StyleType.INFO));
                    this.hoveredIcon.perk.getNextBonusInfo(levelWithBonus + 1).forEach(info -> list.add(info.m_6881_().m_130940_(ChatFormatting.GRAY)));
                }
                boolean hasPerkPoints = this.leftPerkPoints >= (cost = this.hoveredIcon.perk.getCost(baseLevel + 1));
                list.add(LangKey.MESSAGE_COST.getText(hasPerkPoints ? ChatFormatting.AQUA : ChatFormatting.RED, new Object[]{cost}));
                list.add(baseLevel < this.upgradableLevelMax && hasPerkPoints ? LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(ChatFormatting.BLUE, new Object[0]) : LangKey.MESSAGE_CANT_UPGRADE.getText(ChatFormatting.RED, new Object[0]));
            } else {
                list.add(LangKey.MESSAGE_MAX.getText(ChatFormatting.GOLD, new Object[0]));
            }
            list.replaceAll(FontHelper::withFantasyFont);
            guiGraphics.m_280666_(this.f_96547_, list, this.hoveredIcon.minX + 17, this.hoveredIcon.minY);
        }
    }

    private static class PerkIcon {
        public static final int ICON_SIZE = 25;
        private final Perk perk;
        private int localX;
        private int localY;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setLocalPosition(int x, int y) {
            this.localX = x;
            this.localY = y;
        }

        void updatePosition(int areaOffsetX, int areaOffsetY, int areaOriginX, int areaOriginY) {
            this.minX = areaOriginX + this.localX + areaOffsetX;
            this.minY = areaOriginY + this.localY + areaOffsetY;
            this.maxX = this.minX + 25;
            this.maxY = this.minY + 25 + 10;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }
    }

    private static class BonusIcon {
        public static final int ICON_SIZE = 16;
        private final ItemStack stack;
        private final List<Component> tooltips;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        BonusIcon(ItemStack stack, List<Component> tooltips) {
            this.stack = stack;
            this.tooltips = tooltips;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }

        private void render(GuiGraphics guiGraphics) {
            guiGraphics.m_280509_(this.minX - 1, this.minY - 1, this.maxX + 1, this.maxY + 1, -15329733);
            guiGraphics.m_280024_(this.minX, this.minY, this.maxX, this.maxY, -16703669, -7096363);
            guiGraphics.m_280480_(this.stack, this.minX, this.minY);
        }
    }
}

