/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageRitualFlutePlayedNote;
import ovh.corail.tombstone.network.SMessageRitualFluteValidation;

@OnlyIn(value=Dist.CLIENT)
public class ScreenRitualFlute
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tombstone", "textures/gui/bg_music.png");
    private static final Map<Integer, NoteInfo> KEY_TO_NOTE_INFO = new HashMap<Integer, NoteInfo>(){
        {
            this.put(83, new NoteInfo("c", "S", 6, 0, 40));
            this.put(68, new NoteInfo("d", "D", 8, 25, 40));
            this.put(70, new NoteInfo("e", "F", 10, 50, 40));
            this.put(71, new NoteInfo("f", "G", 11, 75, 40));
            this.put(72, new NoteInfo("g", "H", 13, 100, 40));
            this.put(74, new NoteInfo("a", "J", 15, 125, 40));
            this.put(75, new NoteInfo("b", "K", 17, 150, 40));
            this.put(76, new NoteInfo("c'", "L", 18, 175, 40));
            this.put(69, new NoteInfo("c#", "E", 7, 13, 19));
            this.put(82, new NoteInfo("d#", "R", 9, 38, 19));
            this.put(89, new NoteInfo("f#", "Y", 12, 88, 19));
            this.put(85, new NoteInfo("g#", "U", 14, 113, 19));
            this.put(73, new NoteInfo("a#", "I", 16, 138, 19));
        }
    };
    private final List<NoteInfo> currentNotes = new ArrayList<NoteInfo>();
    private final int xSize = 300;
    private final int ySize = 200;
    private int halfWidth;
    private int halfHeight;
    private int guiLeft;
    private int guiTop;
    private boolean inputBlocked = false;
    private Component message = Component.m_237119_();
    private int lastPressedKeyId = -1;
    private int lastPressedKeyTime = 0;
    private boolean isClosing = false;
    private int messageDisplayTicks = 0;
    private boolean freeMode = false;
    private final Set<Integer> noRepeatKeys = new HashSet<Integer>();

    public ScreenRitualFlute() {
        super((Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.title"));
    }

    protected void m_7856_() {
        this.halfWidth = this.f_96543_ / 2;
        this.halfHeight = this.f_96544_ / 2;
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.m_142416_((GuiEventListener)new CustomButton(this.halfWidth - 25, this.halfHeight - 5, 50, 10, (Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.ritual_mode"), btn -> {
            this.freeMode = !this.freeMode;
            btn.m_93666_((Component)Component.m_237115_((String)(this.freeMode ? "tombstone.gui.ritual_flute.free_mode" : "tombstone.gui.ritual_flute.ritual_mode")));
            this.currentNotes.clear();
            this.inputBlocked = false;
            this.setMessage((Component)Component.m_237110_((String)"tombstone.gui.ritual_flute.mode_activated", (Object[])new Object[]{Component.m_237115_((String)("tombstone.gui.ritual_flute." + (this.freeMode ? "free" : "ritual") + "_mode"))}).m_130948_(StyleType.COLOR_GREEN));
        }, () -> true));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.noRepeatKeys.add(keyCode)) {
            return false;
        }
        if (!this.freeMode && keyCode == 259) {
            this.currentNotes.clear();
            return true;
        }
        NoteInfo noteInfo = KEY_TO_NOTE_INFO.get(keyCode);
        if (noteInfo != null && this.lastPressedKeyTime < 17) {
            if (this.freeMode || this.currentNotes.size() < 8) {
                this.resetMessage();
                this.currentNotes.add(noteInfo);
                this.lastPressedKeyId = noteInfo.noteId;
                this.lastPressedKeyTime = 20;
                PacketHandler.sendToServer(new SMessageRitualFlutePlayedNote(noteInfo.noteId));
                if (!this.freeMode && this.currentNotes.size() == 8) {
                    int[] notes = new int[8];
                    for (int i = 0; i < this.currentNotes.size(); ++i) {
                        notes[i] = this.currentNotes.get((int)i).noteId;
                    }
                    PacketHandler.sendToServer(new SMessageRitualFluteValidation(notes));
                    this.inputBlocked = true;
                }
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.noRepeatKeys.remove(keyCode);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void onValidationResult(boolean valid) {
        if (valid) {
            this.setMessage((Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.melody_success").m_130948_(StyleType.COLOR_GREEN));
            this.isClosing = true;
        } else {
            this.setMessage((Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.melody_failed").m_130948_(StyleType.COLOR_RED));
            this.currentNotes.clear();
            this.inputBlocked = false;
        }
        Optional.ofNullable(Minecraft.m_91087_().f_91074_).ifPresent(p -> p.m_5496_(valid ? SoundEvents.f_12275_ : SoundEvents.f_12507_, 1.0f, 1.0f));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize);
        RenderSystem.disableBlend();
        int baseColor = -1875;
        guiGraphics.m_280509_(this.halfWidth - 51, this.guiTop + 2, this.halfWidth + 51, this.guiTop + 14, -1);
        guiGraphics.m_280509_(this.halfWidth - 50, this.guiTop + 3, this.halfWidth + 50, this.guiTop + 13, -8481796);
        guiGraphics.m_280653_(this.f_96547_, FontHelper.withFantasyFont((Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.title")), this.halfWidth, this.guiTop + 4, baseColor);
        if (!this.freeMode) {
            guiGraphics.m_280653_(this.f_96547_, FontHelper.withFantasyFont((Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.played_notes")), this.halfWidth, this.guiTop + 50, baseColor);
        }
        if (this.inputBlocked && !this.isClosing) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.waiting_validation"), this.halfWidth, this.guiTop + 20, -1);
        } else if (this.messageDisplayTicks > 0) {
            guiGraphics.m_280653_(this.f_96547_, this.message, this.halfWidth, this.guiTop + 20, -1);
        }
        int squareSize = 20;
        int startLeft = this.guiLeft + (this.xSize - 196) / 2;
        if (!this.freeMode) {
            for (int i = 0; i < 8; ++i) {
                int startX = startLeft + i * 25;
                int startY = this.guiTop + 65;
                guiGraphics.m_280509_(startX - 1, startY - 1, startX + squareSize + 1, startY + squareSize + 1, baseColor);
                guiGraphics.m_280509_(startX, startY, startX + squareSize, startY + squareSize, -16777216);
                this.drawCenteredStringWithoutShadow(guiGraphics, (Component)(i < this.currentNotes.size() ? FontHelper.withFantasyFont((Component)Component.m_237113_((String)this.currentNotes.get((int)i).noteName)) : Component.m_237113_((String)"\ud83c\udfb5")), startX + squareSize / 2, startY + 6, -8481796);
            }
        }
        for (NoteInfo noteInfo : KEY_TO_NOTE_INFO.values()) {
            int startX = startLeft + noteInfo.x;
            int startY = this.halfHeight + noteInfo.y;
            boolean pressed = noteInfo.noteId == this.lastPressedKeyId;
            guiGraphics.m_280509_(startX - 1, startY - 1, startX + squareSize + 1, startY + squareSize + 1, baseColor);
            guiGraphics.m_280509_(startX, startY, startX + squareSize, startY + squareSize, pressed ? -32 : -16777216);
            this.drawCenteredStringWithoutShadow(guiGraphics, (Component)Component.m_237113_((String)noteInfo.keyName), startX + squareSize / 2, startY + 2, -8481796);
            Component component = FontHelper.withFantasyFont((Component)Component.m_237113_((String)noteInfo.noteName));
            int n = startX + squareSize / 2;
            Objects.requireNonNull(this.f_96547_);
            this.drawCenteredStringWithoutShadow(guiGraphics, component, n, startY + 2 + 9, -8481796);
        }
        if (!this.freeMode) {
            guiGraphics.m_280653_(this.f_96547_, FontHelper.withFantasyFont((Component)Component.m_237115_((String)"tombstone.gui.ritual_flute.backward_to_reset")), this.halfWidth, this.halfHeight + 70, baseColor);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void drawCenteredStringWithoutShadow(GuiGraphics guiGraphics, Component component, int x, int y, int color) {
        guiGraphics.m_280614_(this.f_96547_, component, x - this.f_96547_.m_92852_((FormattedText)component) / 2, y, color, false);
    }

    private void setMessage(Component message) {
        this.message = message;
        this.messageDisplayTicks = 40;
    }

    private void resetMessage() {
        this.message = Component.m_237119_();
        this.messageDisplayTicks = 0;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.messageDisplayTicks > 0 && --this.messageDisplayTicks == 0) {
            this.resetMessage();
            if (this.isClosing) {
                this.m_7379_();
            }
        }
        if (this.lastPressedKeyTime > 0 && --this.lastPressedKeyTime == 0) {
            this.lastPressedKeyId = -1;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private record NoteInfo(String noteName, String keyName, int noteId, int x, int y) {
    }
}

