/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.CharMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.StyleType;

public class FontHelper {
    private static final CharMatcher ALLOWED_CHAR = CharMatcher.anyOf((CharSequence)"abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.:,;'\"(!?)+-*/_\u00e9\u00e8\u00e0\u00e7\u00f9\u00ea\u00fb\u00e2\u00eb");

    public static void drawCentered(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        FontHelper.drawCentered(guiGraphics, font, text.m_7532_(), x, y, color);
    }

    public static void drawCentered(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, float x, float y, int color) {
        guiGraphics.drawString(font, text, x - (float)font.m_92724_(text) / 2.0f, y, color, false);
    }

    public static void drawCenteredFantasy(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        FontHelper.drawCentered(guiGraphics, font, FontHelper.withFantasyFont(text), x, y, color);
    }

    public static void drawFantasy(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        guiGraphics.drawString(font, FontHelper.withFantasyFont(text).getString(), x, y, color, false);
    }

    private static Component withFantasyFont(Component component, FontSize fontSize) {
        if (((ConfigTombstone.Client.FontRule)((Object)ConfigTombstone.client.fontRule.get())).isVanilla()) {
            return component;
        }
        String langCode = Minecraft.m_91087_().f_91066_.f_92075_;
        if (langCode.startsWith("en") || langCode.startsWith("fr") || langCode.startsWith("es") || langCode.startsWith("nl")) {
            return component.m_6881_().m_130948_(fontSize == FontSize.NORMAL ? StyleType.FANTASY_NORMAL : (fontSize == FontSize.SMALL ? StyleType.FANTASY_SMALL : StyleType.FANTASY_LARGE));
        }
        return component;
    }

    public static Component withFantasyFont(Component component) {
        return FontHelper.withFantasyFont(component, FontSize.NORMAL);
    }

    public static Component withSmallFantasyFont(Component component) {
        return FontHelper.withFantasyFont(component, FontSize.SMALL);
    }

    public static Component withLargeFantasyFont(Component component) {
        return FontHelper.withFantasyFont(component, FontSize.LARGE);
    }

    public static boolean canBeFantasy(String text) {
        return ALLOWED_CHAR.matchesAllOf((CharSequence)text);
    }

    private static enum FontSize {
        NORMAL,
        SMALL,
        LARGE;

    }
}

