/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.entity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.PlacedBlocksTracker;
import ovh.corail.tombstone.helper.PrayerHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.CMessagePlayerCapSetWatcherKnowledge;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTags;

public class RitualFluteHandler {
    private static final Map<List<Integer>, Consumer<ServerPlayer>> SEQUENCES = Map.ofEntries(Map.entry(List.of(Integer.valueOf(10), Integer.valueOf(13), Integer.valueOf(10), Integer.valueOf(6), Integer.valueOf(11), Integer.valueOf(15), Integer.valueOf(11), Integer.valueOf(8)), RitualFluteHandler::onHealDeadCoral), Map.entry(List.of(Integer.valueOf(10), Integer.valueOf(13), Integer.valueOf(15), Integer.valueOf(13), Integer.valueOf(11), Integer.valueOf(10), Integer.valueOf(8), Integer.valueOf(6)), RitualFluteHandler::onRitualOfCoralChant), Map.entry(List.of(Integer.valueOf(8), Integer.valueOf(11), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(13), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(8)), RitualFluteHandler::onRitualOfRemanence));
    private static final Map<UUID, Long> LAST_NOTE_TIME = new ConcurrentHashMap<UUID, Long>();

    public static boolean validateSequence(ServerPlayer serverPlayer, int[] noteArray) {
        if (EntityHelper.hasGlobalItemCooldown((Player)serverPlayer, ModItems.ritual_flute)) {
            return false;
        }
        List<Integer> notes = Arrays.stream(noteArray).boxed().toList();
        for (Map.Entry<List<Integer>, Consumer<ServerPlayer>> entry : SEQUENCES.entrySet()) {
            List<Integer> sequence = entry.getKey();
            if (notes.size() != sequence.size() || !sequence.equals(notes)) continue;
            CallbackHandler.addCallback(40, () -> ((Consumer)entry.getValue()).accept(serverPlayer));
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, ModItems.ritual_flute, 100);
            return true;
        }
        return false;
    }

    public static void onRitualOfRemanence(ServerPlayer serverPlayer) {
        if (EntityHelper.getCustomStat(serverPlayer, ModStats.ERDOS_FRAGMENTS) < 4) {
            LangKey.MESSAGE_WATCHER_KNOWLEDGE_3_FIND_ERDOS_FRAGMENTS.sendMessage((Player)serverPlayer, new Object[0]);
            return;
        }
        @Nullable BlockPos pos = PrayerHelper.findPrayableBlock(serverPlayer.m_284548_(), serverPlayer.m_20183_());
        if (pos == null) {
            return;
        }
        Optional<BlockEntityDecorativeGrave> blockEntity = Helper.getDecorativeGrave((Level)serverPlayer.m_284548_(), pos);
        if (blockEntity.isPresent()) {
            if (blockEntity.get().applyScreaming(serverPlayer)) {
                return;
            }
            serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).filter(cap -> !cap.hasWatcherKnowledge(4)).ifPresent(cap -> {
                cap.rewardKnowledge(serverPlayer, 10);
                cap.unlockWatcherKnowledge(4);
                PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(cap.getWatcherKnowledge()), serverPlayer);
                LangKey.MESSAGE_WATCHER_KNOWLEDGE_3_UNLOCKED.sendMessage((Player)serverPlayer, new Object[0]);
            });
            EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.remanence, TimeHelper.tickFromMinute(15), 2, new boolean[0]);
            MutableComponent effectName = ModEffects.remanence.m_19482_().m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPELL, new Object[]{effectName});
            blockEntity.get().applySpammingRite(TimeHelper.worldTicks((Level)serverPlayer.m_284548_()));
        } else {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
    }

    public static void onRitualOfCoralChant(ServerPlayer serverPlayer) {
        if (EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT) < 4) {
            LangKey.MESSAGE_WATCHER_KNOWLEDGE_2_FIND_CORAL_CHANT.sendMessage((Player)serverPlayer, new Object[0]);
            return;
        }
        @Nullable BlockPos pos = PrayerHelper.findPrayableBlock(serverPlayer.m_284548_(), serverPlayer.m_20183_());
        if (pos == null) {
            return;
        }
        Optional<BlockEntityDecorativeGrave> blockEntity = Helper.getDecorativeGrave((Level)serverPlayer.m_284548_(), pos);
        if (blockEntity.isPresent()) {
            if (blockEntity.get().applyScreaming(serverPlayer)) {
                return;
            }
            serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).filter(cap -> !cap.hasWatcherKnowledge(2)).ifPresent(cap -> {
                cap.rewardKnowledge(serverPlayer, 10);
                cap.unlockWatcherKnowledge(2);
                PacketHandler.sendToPlayer(new CMessagePlayerCapSetWatcherKnowledge(cap.getWatcherKnowledge()), serverPlayer);
                LangKey.MESSAGE_WATCHER_KNOWLEDGE_2_UNLOCKED.sendMessage((Player)serverPlayer, new Object[0]);
            });
            EffectHelper.addEffect((LivingEntity)serverPlayer, ModEffects.aquatic_life, TimeHelper.tickFromMinute(15));
            MutableComponent effectName = ModEffects.aquatic_life.m_19482_().m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPELL, new Object[]{effectName});
            blockEntity.get().applySpammingRite(TimeHelper.worldTicks((Level)serverPlayer.m_284548_()));
        } else {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
    }

    public static void onHealDeadCoral(ServerPlayer serverPlayer) {
        int count = EntityHelper.getCustomStat(serverPlayer, ModStats.CORAL_CHANT);
        if (count < 1) {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
            return;
        }
        int radius = 3;
        ArrayList coralItems = new ArrayList();
        PlacedBlocksTracker placedBlocksTracker = PlacedBlocksTracker.get(serverPlayer.m_284548_());
        BlockPos.m_121990_((BlockPos)serverPlayer.m_20183_().m_7918_(-radius, -1, -radius), (BlockPos)serverPlayer.m_20183_().m_7918_(radius, 1, radius)).forEach(pos -> {
            BlockState state = serverPlayer.m_284548_().m_8055_(pos);
            if (state.m_204336_(ModTags.Blocks.dead_corals)) {
                if (placedBlocksTracker.contains((BlockPos)pos)) {
                    return;
                }
                Optional.ofNullable(RitualFluteHandler.getCoralItemFrom(state.m_60734_())).ifPresent(coralItem -> {
                    coralItems.add(coralItem);
                    serverPlayer.m_284548_().m_7471_(pos, false);
                });
            }
        });
        if (!coralItems.isEmpty()) {
            if (count == 1) {
                LootHelper.rewardReadableScroll(serverPlayer, LootHelper.ReadableScrollType.CORAL_CHANT, 2);
            }
            EntityHelper.increaseCustomStat(serverPlayer, ModStats.HEALED_CORAL, coralItems.size());
            coralItems.forEach(coralItem -> ItemHandlerHelper.giveItemToPlayer((Player)serverPlayer, (ItemStack)new ItemStack((ItemLike)coralItem)));
            LangKey.MESSAGE_HEAL_CORAL_SUCCESS.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        } else {
            LangKey.MESSAGE_RITUAL_FLUTE_NOTHING_HAPPENS.sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
        }
    }

    @Nullable
    private static Item getCoralItemFrom(Block deadBlock) {
        if (deadBlock == Blocks.f_50580_) {
            return Items.f_42286_;
        }
        if (deadBlock == Blocks.f_50581_) {
            return Items.f_42287_;
        }
        if (deadBlock == Blocks.f_50582_) {
            return Items.f_42288_;
        }
        if (deadBlock == Blocks.f_50583_) {
            return Items.f_42289_;
        }
        if (deadBlock == Blocks.f_50579_) {
            return Items.f_42285_;
        }
        if (deadBlock == Blocks.f_50548_ || deadBlock == Blocks.f_50558_) {
            return Items.f_42301_;
        }
        if (deadBlock == Blocks.f_50549_ || deadBlock == Blocks.f_50559_) {
            return Items.f_42302_;
        }
        if (deadBlock == Blocks.f_50550_ || deadBlock == Blocks.f_50560_) {
            return Items.f_42356_;
        }
        if (deadBlock == Blocks.f_50551_ || deadBlock == Blocks.f_50561_) {
            return Items.f_42357_;
        }
        if (deadBlock == Blocks.f_50547_ || deadBlock == Blocks.f_50557_) {
            return Items.f_42300_;
        }
        if (deadBlock == Blocks.f_50590_) {
            return Items.f_42291_;
        }
        if (deadBlock == Blocks.f_50591_) {
            return Items.f_42292_;
        }
        if (deadBlock == Blocks.f_50592_) {
            return Items.f_42293_;
        }
        if (deadBlock == Blocks.f_50593_) {
            return Items.f_42294_;
        }
        if (deadBlock == Blocks.f_50589_) {
            return Items.f_42290_;
        }
        return null;
    }

    public static void playNote(ServerPlayer serverPlayer, int noteId) {
        UUID uuid;
        long now = System.currentTimeMillis();
        if (now - LAST_NOTE_TIME.getOrDefault(uuid = serverPlayer.m_20148_(), 0L) < 150L) {
            return;
        }
        LAST_NOTE_TIME.put(uuid, now);
        if (noteId >= 0 && noteId < 25) {
            float pitch = (float)Math.pow(2.0, (double)(noteId - 12) / 12.0);
            serverPlayer.m_284548_().m_5594_(null, serverPlayer.m_20183_(), (SoundEvent)SoundEvents.f_12212_.get(), SoundSource.PLAYERS, 0.5f, pitch);
            serverPlayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_123758_, serverPlayer.m_20182_().f_82479_ + (Helper.RANDOM.nextDouble() - 0.5) * 2.0, serverPlayer.m_20182_().f_82480_ + Helper.RANDOM.nextDouble() * 1.5 + 0.5, serverPlayer.m_20182_().f_82481_ + (Helper.RANDOM.nextDouble() - 0.5) * 2.0, 3, 0.3, 0.0, 0.3, 0.1);
        }
    }
}

