/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.VanillaStructures;

public class WorldHelper {
    private static final Map<String, Component> BIOME_NAMES = new ConcurrentHashMap<String, Component>();
    private static final Map<String, Component> STRUCTURE_NAMES = new ConcurrentHashMap<String, Component>();
    private static final Map<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>> STRUCTURES_BY_WORLD = new ConcurrentHashMap<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>>();

    public static Component getBiomeName(String id) {
        return WorldHelper.getName(id, true);
    }

    public static Component getStructureName(String id) {
        return WorldHelper.getName(id, false);
    }

    private static Component getName(String id, boolean isBiome) {
        return (isBiome ? BIOME_NAMES : STRUCTURE_NAMES).computeIfAbsent(id, k -> {
            String[] splits = id.toLowerCase(Locale.ROOT).split(":");
            MutableComponent structureName = Component.m_237113_((String)Helper.capitalizeWord(splits[splits.length - 1].replace("_", " ")));
            return structureName.m_130946_(" [").m_130946_(splits.length < 2 ? "Minecraft" : Helper.capitalizeWord(splits[0].replace("_", " "))).m_130946_("]");
        });
    }

    public static Location findNearestBiome(ServerLevel level, BlockPos pos, Predicate<Holder<Biome>> predic) {
        BlockPos startingPos = new BlockPos(pos.m_123341_(), WorldHelper.getHeightmapY(level, Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        for (int nbTry = 0; nbTry < 3; ++nbTry) {
            Pair result = level.m_215069_(predic, startingPos = WorldHelper.getCloserValidPos((Level)level, startingPos.m_7918_((int)((double)nbTry * Helper.RANDOM.nextGaussian() * 5000.0), 0, (int)((double)nbTry * Helper.RANDOM.nextGaussian() * 5000.0))), 6400, 32, 64);
            if (result == null || !WorldHelper.isValidPos((Level)level, (BlockPos)result.getFirst())) continue;
            return new Location((BlockPos)result.getFirst(), (Level)level);
        }
        return Location.ORIGIN;
    }

    public static org.apache.commons.lang3.tuple.Pair<Location, ResourceLocation> findNearestStructure(ServerLevel level, BlockPos pos, TagKey<Structure> tagKey, boolean unexplored) {
        return WorldHelper.asHolderSet(level, tagKey).map(holders -> WorldHelper.findNearestStructure(level, pos, (HolderSet<Structure>)holders, unexplored)).orElseGet(() -> org.apache.commons.lang3.tuple.Pair.of((Object)Location.ORIGIN, null));
    }

    public static org.apache.commons.lang3.tuple.Pair<Location, ResourceLocation> findNearestStructure(ServerLevel level, BlockPos pos, HolderSet<Structure> holderset, boolean unexplored) {
        if (level.m_7654_().m_129910_().m_246337_().m_247749_()) {
            Optional<ResourceLocation> optionalRL;
            BlockPos startingPos = WorldHelper.getCloserValidPos((Level)level, pos);
            Pair res = level.m_7726_().m_8481_().m_223037_(level, holderset, startingPos, 100, unexplored);
            if (res != null && WorldHelper.isValidPos((Level)level, (BlockPos)res.getFirst()) && (optionalRL = ((Holder)res.getSecond()).m_203543_().map(ResourceKey::m_135782_)).isPresent()) {
                return org.apache.commons.lang3.tuple.Pair.of((Object)new Location(((BlockPos)res.getFirst()).m_123341_(), WorldHelper.getY(optionalRL.get(), level, pos.m_123341_(), pos.m_123343_()), ((BlockPos)res.getFirst()).m_123343_(), (Level)level), (Object)optionalRL.get());
            }
        }
        return org.apache.commons.lang3.tuple.Pair.of((Object)Location.ORIGIN, null);
    }

    public static Location findNearestVillage(ServerLevel level, BlockPos pos) {
        return (Location)WorldHelper.findNearestStructure(level, pos, (TagKey<Structure>)StructureTags.f_215889_, false).getLeft();
    }

    public static boolean hasStructureInWorld(ServerLevel level, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        return STRUCTURES_BY_WORLD.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), levelKey -> new Object2BooleanOpenHashMap()).computeIfAbsent((Object)structureRL, rl -> {
            Set possibleBiomes = level.m_7726_().m_8481_().m_62218_().m_207840_();
            return structureBiomes.m_203614_().anyMatch(possibleBiomes::contains);
        });
    }

    @Nullable
    public static HolderSet<Structure> getRandomStructure(ServerLevel level, Predicate<ResourceLocation> predic) {
        ResourceLocation structureRL = Helper.getRandomInList(level.m_9598_().m_175515_(Registries.f_256944_).m_6566_().stream().filter(predic).collect(Collectors.toList())).orElse(null);
        if (structureRL != null) {
            VanillaStructures vanillaStructure;
            if ("minecraft".equals(structureRL.m_135827_()) && (vanillaStructure = VanillaStructures.getStructure(structureRL)) != null) {
                return vanillaStructure.asHolderSet(level);
            }
            return WorldHelper.asHolderSet(level, structureRL);
        }
        return null;
    }

    public static int getY(ResourceLocation structureRL, ServerLevel serverLevel, int x, int z) {
        return Optional.ofNullable(VanillaStructures.getStructure(structureRL)).map(vanillaStructure -> switch (vanillaStructure) {
            default -> throw new IncompatibleClassChangeError();
            case VanillaStructures.RUINED_PORTAL -> 70;
            case VanillaStructures.NETHER_FOSSIL -> 65;
            case VanillaStructures.FORTRESS, VanillaStructures.END_CITY -> 60;
            case VanillaStructures.MINESHAFT -> 40;
            case VanillaStructures.BASTION_REMNANT -> 35;
            case VanillaStructures.STRONGHOLD -> 0;
            case VanillaStructures.ANCIENT_CITY -> -30;
            case VanillaStructures.SHIPWRECK -> WorldHelper.getHeightmapY(serverLevel, structureRL.m_135815_().contains("beached") ? Heightmap.Types.WORLD_SURFACE : Heightmap.Types.OCEAN_FLOOR, x, z);
            case VanillaStructures.MONUMENT, VanillaStructures.OCEAN_RUIN -> WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.OCEAN_FLOOR, x, z);
            case VanillaStructures.VILLAGE, VanillaStructures.PILLAGER_OUTPOST, VanillaStructures.DESERT_PYRAMID, VanillaStructures.JUNGLE_TEMPLE, VanillaStructures.IGLOO, VanillaStructures.MANSION, VanillaStructures.SWAMP_HUT, VanillaStructures.BURIED_TREASURE, VanillaStructures.TRAIL_RUINS -> WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.WORLD_SURFACE, x, z);
        }).orElseGet(() -> {
            if (structureRL.m_135827_().equals("tombstone") && structureRL.m_135815_().equals("abandoned_grave_ocean")) {
                return WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.OCEAN_FLOOR, x, z);
            }
            return WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.WORLD_SURFACE, x, z);
        });
    }

    public static Optional<HolderSet.Named<Structure>> asHolderSet(ServerLevel level, TagKey<Structure> tagKey) {
        return level.m_9598_().m_255025_(Registries.f_256944_).m_254901_(tagKey);
    }

    @Nullable
    public static HolderSet<Structure> asHolderSet(ServerLevel level, ResourceLocation resourceLocation) {
        return WorldHelper.asHolderSet(level, (ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)resourceLocation));
    }

    @Nullable
    public static HolderSet<Structure> asHolderSet(ServerLevel level, ResourceKey<Structure> resourceKey) {
        return level.m_9598_().m_255025_(Registries.f_256944_).m_254902_(resourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).orElse(null);
    }

    public static int getHeightmapY(ServerLevel serverLevel, Heightmap.Types heightmapType, int x, int z) {
        serverLevel.m_8055_(new BlockPos(x, 75, z));
        return serverLevel.m_6924_(heightmapType, x, z);
    }

    public static BlockPos getCloserValidPos(Level level, BlockPos pos) {
        boolean validY;
        WorldBorder border = level.m_6857_();
        boolean validXZ = border.m_61937_(pos);
        boolean bl = validY = !level.m_151570_(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!validXZ) {
            x = Math.min(Math.max(pos.m_123341_(), (int)border.m_61955_()), (int)border.m_61957_());
            z = Math.min(Math.max(pos.m_123343_(), (int)border.m_61956_()), (int)border.m_61958_());
        }
        if (!validY) {
            y = Mth.m_14045_((int)pos.m_123342_(), (int)level.m_141937_(), (int)(level.m_141937_() + level.m_6042_().f_63865_()));
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(@Nullable Level level, BlockPos pos) {
        return level != null && level.m_6857_().m_61937_(pos) && !WorldHelper.isOutsideBuildHeight(level, pos);
    }

    public static boolean isOutsideWorldBorders(Level level, BlockPos pos) {
        return !level.m_6857_().m_61937_(pos);
    }

    public static boolean isOutsideBuildHeight(Level level, BlockPos pos) {
        return level.m_151570_(pos);
    }

    public static void clear() {
        BIOME_NAMES.clear();
        STRUCTURE_NAMES.clear();
        STRUCTURES_BY_WORLD.clear();
    }
}

