/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemReceptacleOfFamiliar
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final String CAPTURABLE_TYPE_NBT_STRING = "capturable_type";
    private static final String DEAD_PET_NBT_COMPOUND = "dead_pet";

    public ItemReceptacleOfFamiliar() {
        super("receptacle_of_familiar", ItemReceptacleOfFamiliar.getBuilder().m_41487_(1).m_41486_(), () -> SharedConfigTombstone.allowed_magic_items.allowReceptacleOfFamiliar.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        CompoundTag pet_tag = this.getDeadPetTag(stack).orElse(null);
        if (pet_tag == null) {
            this.addItemDesc(tooltip, "1", new Object[0]);
            String id = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
            if (!id.isEmpty()) {
                tooltip.add((Component)LangKey.MESSAGE_IMPREGNATE.getText(StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.getEntityName(id)}));
            }
        } else if (pet_tag.m_128425_("id", 8)) {
            String id = pet_tag.m_128461_("id");
            this.addItemDesc(tooltip, "2", LangKey.getEntityName(id));
            ResourceLocation rl = new ResourceLocation(id);
            Optional<LangKey> typeName = TamableType.getTypeLangKey(rl);
            tooltip.add((Component)LangKey.MESSAGE_TYPE.getText(typeName.isEmpty() ? StyleType.COLOR_RED : StyleType.COLOR_GREEN, new Object[]{typeName.orElse(LangKey.MESSAGE_UNKNOWN).getText(new Object[0]), Helper.capitalizeWord(rl.m_135827_())}));
            this.addItemUse(tooltip, this.getDurabilityRatio(stack) == 0.0 ? "2" : "1", new Object[0]);
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        if (EntityHelper.isValidServerPlayer((Entity)player) && !NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING).isEmpty()) {
            ModTriggers.IMPREGNATED_RECEPTACLE.trigger((ServerPlayer)player);
        }
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.containSoul(stack) || super.m_5812_(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && stack.m_150930_((Item)this) && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity, TimeHelper.tickFromSecond(30))) {
            this.getDeadPetTag(stack).ifPresent(pet_tag -> {
                float maxHealth;
                float health = pet_tag.m_128425_("Health", 5) ? Math.max(0.0f, pet_tag.m_128457_("Health")) : 1.0f;
                float f = maxHealth = pet_tag.m_128425_("max_life", 5) ? Math.max(1.0f, pet_tag.m_128457_("max_life")) : 1.0f;
                if (health < maxHealth) {
                    float gain = maxHealth * 0.1f;
                    pet_tag.m_128350_("Health", Math.min(health + gain, maxHealth));
                }
            });
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged ? super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) : oldStack.m_41720_() != newStack.m_41720_();
    }

    public double getDurabilityRatio(ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> {
            float health = pet_tag.m_128425_("Health", 5) ? Math.max(0.0f, pet_tag.m_128457_("Health")) : 1.0f;
            float maxHealth = pet_tag.m_128425_("max_life", 5) ? Math.max(1.0f, pet_tag.m_128457_("max_life")) : 1.0f;
            return 1.0 - (double)health / (double)maxHealth;
        }).orElse(1.0);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.containSoul(stack) && this.getDurability(stack) > 0.0;
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)(1.0 - this.getDurability(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)this.getDurability(stack) * 13.0f);
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (!this.containSoul(stack)) {
            EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_EMPTY_RECEPTACLE.getText(new Object[0]));
        }
        if (this.getDurability(stack) > 0.0) {
            EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECOVERING_RECEPTACLE.getText(new Object[0]));
        }
        if (!this.revive((Player)player, gravePos, stack, false)) {
            stack.m_41749_(DEAD_PET_NBT_COMPOUND);
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.getText(LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])));
        }
        ModTriggers.REVIVE_FAMILIAR.trigger(player);
        stack.m_41774_(1);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_REVIVE_FAMILIAR.getText(LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])), 1);
    }

    @Override
    public int getKnowledge() {
        return 5;
    }

    @Override
    public int getCorruptionLevel(ItemStack stack) {
        return this.containSoul(stack) ? 10 : 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new SoulConsumerProvider(this);
    }

    private double getDurability(ItemStack stack) {
        return this.getDeadPetTag(stack).map(pet_tag -> {
            float health = pet_tag.m_128425_("Health", 5) ? Math.max(0.0f, pet_tag.m_128457_("Health")) : 1.0f;
            float maxHealth = pet_tag.m_128425_("max_life", 5) ? Math.max(1.0f, pet_tag.m_128457_("max_life")) : 1.0f;
            return 1.0 - (double)health / (double)maxHealth;
        }).orElse(1.0);
    }

    public boolean containSoul(ItemStack stack) {
        return stack.m_150930_((Item)this) && stack.m_41783_() != null && stack.m_41783_().m_128425_(DEAD_PET_NBT_COMPOUND, 10);
    }

    private Optional<CompoundTag> getDeadPetTag(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(tag -> tag.m_128425_(DEAD_PET_NBT_COMPOUND, 10)).map(tag -> tag.m_128469_(DEAD_PET_NBT_COMPOUND));
    }

    public boolean revive(Player player, BlockPos gravePos, ItemStack stack, boolean unequip) {
        return this.getDeadPetTag(stack).map(pet_tag -> pet_tag.m_128425_("id", 8) && EntityType.m_20632_((String)pet_tag.m_128461_("id")).map(entityType -> {
            LivingEntity entity = (LivingEntity)entityType.m_20615_(player.m_9236_());
            if (entity == null) {
                return false;
            }
            if (pet_tag.m_128441_("is_spellcaster")) {
                entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> cap.setSpellCaster(ServantEntityImpl.CasterType.getRandomId()));
            }
            boolean hasData = false;
            if (pet_tag.m_128441_("max_life")) {
                try {
                    entity.m_20258_(pet_tag);
                    hasData = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            entity.m_6034_((double)gravePos.m_123341_() + 0.5, (double)gravePos.m_123342_() + 0.5, (double)gravePos.m_123343_() + 0.5);
            if (!hasData && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6518_((ServerLevelAccessor)((ServerLevel)player.m_9236_()), player.m_9236_().m_6436_(entity.m_20183_()), MobSpawnType.TRIGGERED, null, null);
            }
            entity.m_21153_(entity.m_21233_());
            if (unequip) {
                IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)entity);
                IntStream.range(0, itemHandler.getSlots()).forEach(slot -> {
                    ItemStack currentStack = itemHandler.getStackInSlot(slot);
                    if (!currentStack.m_41619_()) {
                        itemHandler.extractItem(slot, currentStack.m_41613_(), false);
                    }
                });
                if (entity instanceof AbstractChestedHorse) {
                    ((AbstractChestedHorse)entity).m_30504_(false);
                }
            }
            TamableType.setTamedBy(player, (Entity)entity);
            EffectHelper.clearBadEffects(entity);
            entity.m_19877_();
            player.m_9236_().m_7967_((Entity)entity);
            return true;
        }).orElse(false) != false).orElse(false);
    }

    public void setCapturableType(ItemStack stack, String type) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setString(stack, CAPTURABLE_TYPE_NBT_STRING, type);
        }
    }

    private boolean canCaptureSoul(ItemStack stack, LivingEntity entity) {
        String type = NBTStackHelper.getString(stack, CAPTURABLE_TYPE_NBT_STRING);
        return type.isEmpty() || type.equals(RegistryHelper.getRegistryString((Entity)entity));
    }

    public boolean captureSoul(LivingEntity entity) {
        Mob mob;
        boolean hasReceptacle;
        boolean wasOffline;
        if (entity.m_9236_().m_5776_()) {
            return false;
        }
        ResourceLocation entityId = RegistryHelper.getRegistryName(entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        TamableType tamableType = TamableType.getType(entityId);
        if (tamableType == null) {
            return false;
        }
        UUID ownerId = tamableType.getOwnerId((Entity)entity);
        MinecraftServer server = entity.m_20194_();
        if (ownerId == null || server == null) {
            return false;
        }
        @Nullable ServerPlayer owner = server.m_6846_().m_11259_(ownerId);
        boolean bl = wasOffline = owner == null;
        if (wasOffline && (owner = EntityHelper.getOfflinePlayer(server, ownerId)) == null) {
            return false;
        }
        ItemStack receptacle = owner.m_6084_() ? InventoryHelper.findFirstInInventory((Player)owner, stack -> stack.m_150930_((Item)this) && this.canCaptureSoul((ItemStack)stack, entity) && !this.containSoul((ItemStack)stack)) : ItemStack.f_41583_;
        boolean bl2 = hasReceptacle = !receptacle.m_41619_();
        if (hasReceptacle && EventFactory.onCaptureSoul((Player)owner, entity)) {
            hasReceptacle = false;
        }
        if (entity.m_5803_()) {
            entity.m_5796_();
        }
        if (entity.m_20159_()) {
            entity.m_8127_();
        }
        if (entity.m_20160_()) {
            entity.m_20153_();
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_21523_()) {
            mob.m_21455_(true, false);
        }
        CompoundTag pet_tag = entity.serializeNBT();
        pet_tag.m_128473_("Dimension");
        pet_tag.m_128473_("Motion");
        pet_tag.m_128473_("UUID");
        pet_tag.m_128473_("UpdateBlocked");
        pet_tag.m_128350_("Health", 0.0f);
        pet_tag.m_128350_("max_life", entity.m_21233_());
        if (!hasReceptacle) {
            CommandTBReviveFamiliar.saveFamiliar(server, ownerId, pet_tag, entity.m_20148_().toString());
            return false;
        }
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)entity);
        IntStream.range(0, itemHandler.getSlots()).forEach(slot -> {
            ItemStack currentStack = itemHandler.getStackInSlot(slot);
            if (!currentStack.m_41619_()) {
                itemHandler.extractItem(slot, currentStack.m_41613_(), false);
            }
        });
        tamableType.onCapture((Entity)entity, pet_tag);
        receptacle.m_41784_().m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)pet_tag);
        if (wasOffline) {
            EntityHelper.writePlayerData(server, (Player)owner);
        } else {
            LangKey.MESSAGE_CAPTURE_FAMILIAR.sendSpecialMessage((Player)owner, entity.m_7755_());
            ModTriggers.CAPTURE_SOUL.trigger(owner);
        }
        return true;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(DEAD_PET_NBT_COMPOUND, 10)) {
            CompoundTag tag = stack.m_41783_().m_6426_();
            CompoundTag pet_tag = tag.m_128469_(DEAD_PET_NBT_COMPOUND);
            if (pet_tag.m_128425_("id", 8)) {
                CompoundTag newTag = new CompoundTag();
                newTag.m_128359_("id", pet_tag.m_128461_("id"));
                if (pet_tag.m_128441_("Health")) {
                    newTag.m_128350_("Health", pet_tag.m_128457_("Health"));
                }
                if (pet_tag.m_128441_("max_life")) {
                    newTag.m_128350_("max_life", pet_tag.m_128457_("max_life"));
                }
                tag.m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)newTag);
            } else {
                pet_tag.m_128473_(DEAD_PET_NBT_COMPOUND);
            }
            return tag;
        }
        return stack.m_41783_();
    }

    public ItemStack setRandomFamiliar(ItemStack stack) {
        if (stack.m_150930_((Item)this)) {
            CompoundTag pet_tag = new CompoundTag();
            ResourceLocation type = TamableType.getRandomTamableEntityType();
            pet_tag.m_128359_("id", type.toString());
            if (TamableType.getType(type) == TamableType.UNDEAD && Helper.RANDOM.nextInt(10) == 0) {
                pet_tag.m_128379_("is_spellcaster", true);
            }
            stack.m_41784_().m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)pet_tag);
        }
        return stack;
    }

    public ItemStack createReceptacleWithFamiliar(ResourceLocation id) {
        ItemStack receptacle = new ItemStack((ItemLike)this);
        CompoundTag pet_tag = new CompoundTag();
        pet_tag.m_128359_("id", id.toString());
        receptacle.m_41784_().m_128365_(DEAD_PET_NBT_COMPOUND, (Tag)pet_tag);
        return receptacle;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return this.setRandomFamiliar(stack);
    }
}

