/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll {
    private final SpellBuff spellBuff;

    public ItemScrollBuff(SpellBuff spellBuff) {
        super("scroll_of_" + spellBuff.getName(), ItemScrollBuff.getBuilder().m_41487_(64), spellBuff::isEnabled);
        this.spellBuff = spellBuff;
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        this.addEffectInfo(tooltip, this.spellBuff.potionSupplier.get());
        if (this.isEnchanted(stack)) {
            tooltip.add((Component)(this.isAncient(stack) ? LangKey.MESSAGE_AREA_BUFF : LangKey.MESSAGE_USEABLE_ON_ALLY).getText(new Object[0]).m_130948_(StyleType.EFFECT_DESCRIPTION));
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE2, new Object[0]);
        } else {
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
        }
        tooltip.add((Component)Component.m_237113_((String)("(" + StringUtil.m_14404_((int)Mth.m_14143_((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.rune_inscriber) * 0.1f)))) + ")")).m_6270_(StyleType.MESSAGE_SPELL));
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            ItemStack enchantedStack = NBTStackHelper.setBoolean(new ItemStack((ItemLike)this), "enchant", true);
            toAdd.m_246342_(enchantedStack);
            toAdd.m_246342_(NBTStackHelper.setBoolean(enchantedStack.m_41777_(), "ancient", true));
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            int consume;
            ItemStack enchantedStack = stack.m_41777_();
            enchantedStack.m_41764_(1);
            NBTStackHelper.setBoolean(enchantedStack, "enchant", true);
            int n = consume = !this.isAncient(enchantedStack) && soulStrength > 1 ? 2 : 1;
            if (consume == 2) {
                NBTStackHelper.setBoolean(enchantedStack, "ancient", true);
            }
            stack.m_41774_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)enchantedStack);
            return ISoulConsumer.ConsumeResult.success(consume);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        MobEffectInstance effectInstance = new MobEffectInstance(this.spellBuff.potionSupplier.get(), Mth.m_14143_((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.rune_inscriber) * 0.1f))), this.spellBuff.amplifier);
        MutableComponent effectName = effectInstance.m_19544_().m_19482_().m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
        if (this.isAncient(stack)) {
            List<LivingEntity> allies = level.m_6249_((Entity)player, player.m_20191_().m_82377_(3.0, 0.0, 3.0), e -> e != null && e.m_6084_()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> this.isTargetForCasting((Player)player, (LivingEntity)e)).toList();
            allies.forEach(arg_0 -> ItemScrollBuff.lambda$doEffects$2(effectInstance, (Component)effectName, arg_0));
            ModTriggers.CAST_ON_ALLY.trigger(player, allies.size());
            EffectHelper.addEffect((LivingEntity)player, new MobEffectInstance(effectInstance));
            LangKey.MESSAGE_SPELL_CAST_AROUND.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName});
        } else {
            if (target == null) {
                target = player;
            }
            EffectHelper.addEffect(target, new MobEffectInstance(effectInstance));
            if (EntityHelper.isValidServerPlayer((Entity)target)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)target), StyleType.MESSAGE_SPELL, new Object[]{effectName});
            }
            if (!target.equals((Object)player)) {
                ModTriggers.CAST_ON_ALLY.trigger(player);
                LangKey.MESSAGE_SPELL_CAST_ON_TARGET.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName, target.m_7755_().m_6879_().m_6270_(StyleType.TOOLTIP_ITEM)});
            }
        }
        ModTriggers.SPELL_BUFF.get((Object)this.spellBuff).trigger(player);
        return true;
    }

    @Override
    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return !this.isAncient(stack) && target.m_7301_(new MobEffectInstance(this.spellBuff.potionSupplier.get()));
    }

    private static /* synthetic */ void lambda$doEffects$2(MobEffectInstance effectInstance, Component effectName, LivingEntity e) {
        EffectHelper.addEffect(e, new MobEffectInstance(effectInstance));
        if (EntityHelper.isValidServerPlayer((Entity)e)) {
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)e), StyleType.MESSAGE_SPELL, new Object[]{effectName});
        }
    }

    public static enum SpellBuff {
        PRESERVATION(() -> ModEffects.preservation, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPreservation.get()),
        UNSTABLE_INTANGIBILITY(() -> ModEffects.unstable_intangibility, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibility.get()),
        FEATHER_FALL(() -> ModEffects.feather_fall, 2, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall.get()),
        PURIFICATION(() -> ModEffects.purification, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPurification.get()),
        TRUE_SIGHT(() -> ModEffects.true_sight, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfTrueSight.get()),
        REACH(() -> ModEffects.reach, 4, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfReach.get()),
        LIGHTNING_RESISTANCE(() -> ModEffects.lightning_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfLightningResistance.get()),
        FROST_RESISTANCE(() -> ModEffects.frost_resistance, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFrostResistance.get()),
        AQUATIC_LIFE(() -> ModEffects.aquatic_life, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfAquaticLife.get()),
        MERCY(() -> ModEffects.mercy, 0, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfMercy.get());

        private final Supplier<MobEffect> potionSupplier;
        private final int amplifier;
        private final BooleanSupplier supplierEnabled;

        private SpellBuff(Supplier<MobEffect> potionSupplier, int amplifier, BooleanSupplier supplierEnabled) {
            this.potionSupplier = potionSupplier;
            this.amplifier = amplifier;
            this.supplierEnabled = supplierEnabled;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isEnabled() {
            return this.supplierEnabled.getAsBoolean();
        }

        public Item getItem() {
            return ModItems.scroll_buff.get((Object)this);
        }

        public ItemStack getEnchantedStack() {
            return NBTStackHelper.setBoolean(new ItemStack((ItemLike)this.getItem()), "enchant", true);
        }

        public ItemStack getAncientStack() {
            return NBTStackHelper.setBoolean(this.getEnchantedStack(), "ancient", true);
        }

        public static Optional<ItemStack> getRandomEnchantedScroll(boolean isAncient) {
            return Helper.getRandomInList(Arrays.stream(SpellBuff.values()).filter(SpellBuff::isEnabled).collect(Collectors.toList())).map(buff -> {
                ItemStack stack = NBTStackHelper.setBoolean(new ItemStack((ItemLike)buff.getItem()), "enchant", true);
                if (isAncient) {
                    NBTStackHelper.setBoolean(stack, "ancient", true);
                }
                return stack;
            });
        }
    }
}

