/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.item.ItemSearchable;

public class ItemSeekerRod
extends ItemSearchable {
    public ItemSeekerRod() {
        super("seeker_rod", () -> SharedConfigTombstone.allowed_magic_items.allowSeekerRod.get());
        this.withEffect();
    }

    @Override
    protected void giveReward(ServerPlayer player, BlockPos targetPos) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.rewardKnowledge(player, 3));
        player.m_6756_(300);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)LootHelper.getSeekerRodReward(player.m_284548_(), targetPos, (Player)player));
        LangKey.MESSAGE_SEEKER_ROD.sendMessage((Player)player, new Object[0]);
        player.m_9236_().m_5594_(null, targetPos, SoundEvents.f_11700_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    @Override
    protected BlockEntityType<? extends BlockEntity> getTargetType() {
        return BlockEntityType.f_58909_;
    }

    @Override
    protected String getMessageToDisplay(Player player, ItemStack stack) {
        if (this.isInVillageRange(player, stack)) {
            if (this.isTargetFound(stack)) {
                return LangKey.MESSAGE_USE_SEEKER_ROD.getText(new Object[0]).getString();
            }
            return LangKey.MESSAGE_FIND_BELL.getText(new Object[0]).getString();
        }
        return LangKey.MESSAGE_FOLLOW_PARTICLES.getText(new Object[0]).getString();
    }
}

