/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;

public final class CMessageAllCooldowns {
    private final ListTag cooldownTagList;

    public CMessageAllCooldowns(ListTag cooldownTagList) {
        this.cooldownTagList = cooldownTagList;
    }

    static CMessageAllCooldowns fromBytes(FriendlyByteBuf buf) {
        CompoundTag compound = buf.m_130260_();
        return new CMessageAllCooldowns(Optional.ofNullable(compound).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, "tb_cooldowns")).orElse(new ListTag()));
    }

    static void toBytes(CMessageAllCooldowns msg, FriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("tb_cooldowns", (Tag)msg.cooldownTagList);
        buf.m_130079_(compound);
    }

    public static class Handler {
        static void handle(final CMessageAllCooldowns message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        CooldownHandler.INSTANCE.updateAllClientCooldowns(message.cooldownTagList);
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

